/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaInput;
import com.sun.tools.javac.parser.Tokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

final class ModifierOrderer {
    ModifierOrderer() {
    }

    static JavaInput reorderModifiers(String text) throws FormatterException {
        String string;
        return ModifierOrderer.reorderModifiers(new JavaInput(text), ImmutableList.of$714caac3(Range.closedOpen(0, string.length())));
    }

    /*
     * WARNING - void declaration
     */
    static JavaInput reorderModifiers(JavaInput javaInput, Collection<Range<Integer>> characterRanges) throws FormatterException {
        void var3_3;
        JavaInput javaInput2;
        if (((Input)javaInput).getTokens().isEmpty()) {
            return javaInput;
        }
        RangeSet<Integer> tokenRanges = javaInput.characterRangesToTokenRanges(characterRanges);
        Iterator it = ((ImmutableCollection)((Input)javaInput).getTokens()).iterator();
        TreeRangeMap<Integer, String> replacements = TreeRangeMap.create();
        while (it.hasNext()) {
            boolean bl;
            int end;
            int begin;
            ArrayList<Object> modifierTokens;
            block8: {
                Object tokens = ModifierOrderer.getModifierTokens(it);
                if (((ModifierTokens)tokens).isEmpty() || !((ModifierTokens)tokens).tokens().stream().allMatch(token -> {
                    void var1_1;
                    return tokenRanges.contains(var1_1.getTok().getIndex());
                })) continue;
                modifierTokens = new ArrayList<Object>();
                begin = ((ModifierTokens)tokens).startPosition();
                modifierTokens.add(tokens);
                end = -1;
                while (it.hasNext() && !((ModifierTokens)(tokens = ModifierOrderer.getModifierTokens(it))).isEmpty()) {
                    modifierTokens.add(tokens);
                    end = ((ModifierTokens)tokens).endPosition();
                }
                Object object = modifierTokens;
                tokens = Ordering.natural$75ffd5c5();
                if ((object = object.iterator()).hasNext()) {
                    Object e = object.next();
                    while (object.hasNext()) {
                        Object e2 = object.next();
                        if (((Ordering)tokens).compare(e, e2) > 0) {
                            bl = false;
                            break block8;
                        }
                        e = e2;
                    }
                }
                bl = true;
            }
            if (bl) continue;
            List sorted = Ordering.natural$75ffd5c5().sortedCopy(modifierTokens);
            StringBuilder replacement = new StringBuilder();
            for (int i = 0; i < sorted.size(); ++i) {
                if (i > 0) {
                    ModifierOrderer.addTrivia(replacement, ((ModifierTokens)modifierTokens.get(i)).getToksBefore());
                }
                replacement.append((Object)((ModifierTokens)sorted.get(i)).modifier());
                if (i >= sorted.size() - 1) continue;
                ModifierOrderer.addTrivia(replacement, ((ModifierTokens)modifierTokens.get(i)).getToksAfter());
            }
            replacements.put(Range.closedOpen(begin, end), replacement.toString());
        }
        return ModifierOrderer.applyReplacements(javaInput2, (TreeRangeMap<Integer, String>)var3_3);
    }

    private static void addTrivia(StringBuilder replacement, ImmutableList<? extends Input.Tok> toks) {
        for (Input.Tok tok : toks) {
            replacement.append(tok.getText());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable ModifierTokens getModifierTokens(Iterator<? extends Input.Token> it) {
        void var2_2;
        Iterator<? extends Input.Token> iterator;
        void var1_1;
        Input.Token token = it.next();
        ImmutableList.Builder result = ImmutableList.builder();
        result.add(token);
        if (!token.getTok().getText().equals("non")) {
            return ModifierTokens.create(result.build());
        }
        if (!it.hasNext()) {
            return ModifierTokens.empty();
        }
        Input.Token dash = it.next();
        result.add(dash);
        if (!var1_1.getTok().getText().equals("-") || !it.hasNext()) {
            return ModifierTokens.empty();
        }
        result.add(iterator.next());
        return ModifierTokens.create(var2_2.build());
    }

    private static @Nullable Modifier asModifier(ImmutableList<Input.Token> tokens) {
        Object object;
        if (tokens.size() == 1) {
            return ModifierOrderer.asModifier((Input.Token)tokens.get(0));
        }
        Object modifier = ModifierOrderer.asModifier(Iterables.getLast(tokens));
        if (modifier == null) {
            return null;
        }
        return Modifier.valueOf("NON_" + ((Enum)object).name());
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable Modifier asModifier(Input.Token token) {
        String string;
        Tokens.TokenKind kind = ((JavaInput.Tok)token.getTok()).kind();
        if (kind != null) {
            void var1_1;
            switch (1.$SwitchMap$com$sun$tools$javac$parser$Tokens$TokenKind[var1_1.ordinal()]) {
                case 1: {
                    return Modifier.PUBLIC;
                }
                case 2: {
                    return Modifier.PROTECTED;
                }
                case 3: {
                    return Modifier.PRIVATE;
                }
                case 4: {
                    return Modifier.ABSTRACT;
                }
                case 5: {
                    return Modifier.STATIC;
                }
                case 6: {
                    return Modifier.DEFAULT;
                }
                case 7: {
                    return Modifier.FINAL;
                }
                case 8: {
                    return Modifier.TRANSIENT;
                }
                case 9: {
                    return Modifier.VOLATILE;
                }
                case 10: {
                    return Modifier.SYNCHRONIZED;
                }
                case 11: {
                    return Modifier.NATIVE;
                }
                case 12: {
                    return Modifier.STRICTFP;
                }
            }
        }
        switch (string.getTok().getText()) {
            case "sealed": {
                return Modifier.valueOf("SEALED");
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static JavaInput applyReplacements(JavaInput javaInput, TreeRangeMap<Integer, String> replacementMap) throws FormatterException {
        StringBuilder stringBuilder;
        Iterator iterator;
        TreeRangeMap.AsMapOfRanges ranges = replacementMap.asDescendingMapOfRanges$604efcea();
        if (ranges.isEmpty()) {
            return javaInput;
        }
        StringBuilder sb = new StringBuilder(((Input)javaInput).getText());
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_2;
            void var3_3;
            Range range = (Range)entry.getKey();
            sb.replace((Integer)range.lowerEndpoint(), (Integer)var3_3.upperEndpoint(), (String)var2_2.getValue());
        }
        return new JavaInput(stringBuilder.toString());
    }

    static class ModifierTokens
    implements Comparable<ModifierTokens> {
        private final ImmutableList<Input.Token> tokens;
        private final Modifier modifier;

        static ModifierTokens create(ImmutableList<Input.Token> tokens) {
            ImmutableList<Input.Token> immutableList;
            ImmutableList<Input.Token> immutableList2 = immutableList;
            return new ModifierTokens(immutableList2, ModifierOrderer.asModifier(immutableList2));
        }

        static ModifierTokens empty() {
            return new ModifierTokens(ImmutableList.of(), null);
        }

        /*
         * WARNING - void declaration
         */
        ModifierTokens(ImmutableList<Input.Token> tokens, Modifier modifier) {
            void var2_2;
            void var1_1;
            this.tokens = var1_1;
            this.modifier = var2_2;
        }

        boolean isEmpty() {
            return this.tokens.isEmpty() || this.modifier == null;
        }

        Modifier modifier() {
            return this.modifier;
        }

        ImmutableList<Input.Token> tokens() {
            return this.tokens;
        }

        private Input.Token first() {
            return (Input.Token)this.tokens.get(0);
        }

        private Input.Token last() {
            return Iterables.getLast(this.tokens);
        }

        int startPosition() {
            return this.first().getTok().getPosition();
        }

        int endPosition() {
            return this.last().getTok().getPosition() + this.last().getTok().getText().length();
        }

        ImmutableList<? extends Input.Tok> getToksBefore() {
            return this.first().getToksBefore();
        }

        ImmutableList<? extends Input.Tok> getToksAfter() {
            return this.last().getToksAfter();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(ModifierTokens o) {
            void var1_1;
            Preconditions.checkState(!this.isEmpty());
            return this.modifier.compareTo(var1_1.modifier);
        }
    }
}

