/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.java17;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.YieldTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Name;

public class Java17InputAstVisitor
extends JavaInputAstVisitor {
    /*
     * WARNING - void declaration
     */
    public Java17InputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        super((OpsBuilder)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleModule(boolean afterFirstToken, CompilationUnitTree node) {
        ModuleTree module = node.getModule();
        if (module != null) {
            void var2_2;
            void var1_1;
            if (var1_1 != false) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.markForPartialFormat();
            this.visitModule((ModuleTree)var2_2, null);
            this.builder.forcedBreak();
        }
    }

    @Override
    protected List<? extends Tree> getPermitsClause(ClassTree node) {
        return node.getPermitsClause();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitBindingPattern(BindingPatternTree node, Void unused) {
        void var1_1;
        this.sync(node);
        VariableTree variableTree = node.getVariable();
        this.visitBindingPattern(variableTree.getModifiers(), variableTree.getType(), var1_1.getName());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void visitBindingPattern(ModifiersTree modifiers, Tree type, Name name) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.builder.open(this.plusFour);
        this.declareOne(JavaInputAstVisitor.DeclarationKind.PARAMETER, JavaInputAstVisitor.Direction.HORIZONTAL, Optional.of(var1_1), (Tree)var2_2, (Name)var3_3, "", "", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitYield(YieldTree node, Void aVoid) {
        void var1_1;
        this.sync(node);
        this.token("yield");
        this.builder.space();
        this.scan((Tree)var1_1.getValue(), null);
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitSwitchExpression(SwitchExpressionTree node, Void aVoid) {
        void var1_1;
        this.sync(node);
        this.visitSwitch(node.getExpression(), var1_1.getCases());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitClass(ClassTree tree, Void unused) {
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: {
                this.visitAnnotationType(tree);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                this.visitClassDeclaration(tree);
                break;
            }
            case ENUM: {
                this.visitEnumDeclaration(tree);
                break;
            }
            case RECORD: {
                this.visitRecordDeclaration(tree);
                break;
            }
            default: {
                void var1_1;
                throw new AssertionError((Object)var1_1.getKind());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitRecordDeclaration(ClassTree node) {
        this.sync(node);
        this.typeDeclarationModifiers(node.getModifiers());
        Verify.verify(node.getExtendsClause() == null);
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        this.token("record");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperInterfaceTypes ? this.plusFour : ZERO);
        }
        ImmutableList<JCTree.JCVariableDecl> parameters = Java17InputAstVisitor.recordVariables(node);
        this.token("(");
        if (!parameters.isEmpty()) {
            this.builder.breakToFill("");
        }
        this.visitFormals(Optional.empty(), parameters);
        this.token(")");
        if (hasSuperInterfaceTypes) {
            this.builder.breakToFill(" ");
            this.builder.open(node.getImplementsClause().size() > 1 ? this.plusFour : ZERO);
            this.token("implements");
            this.builder.space();
            boolean afterFirstToken = false;
            for (Tree tree : node.getImplementsClause()) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
        }
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            void var3_3;
            void var1_1;
            List members = var1_1.getMembers().stream().filter(t -> (TreeInfo.flags((JCTree)t) & 0x1000000L) == 0L).collect(ImmutableList.toImmutableList());
            this.addBodyDeclarations((List<? extends Tree>)var3_3, JavaInputAstVisitor.BracesOrNot.YES, JavaInputAstVisitor.FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    private static ImmutableList<JCTree.JCVariableDecl> recordVariables(ClassTree node) {
        return node.getMembers().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).filter(m -> (m.mods.flags & 0x2000000000000000L) == 0x2000000000000000L).collect(ImmutableList.toImmutableList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getExpression(), null);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        if (node.getPattern() != null) {
            this.scan((Tree)node.getPattern(), null);
        } else {
            void var1_1;
            this.scan(var1_1.getType(), null);
        }
        this.builder.close();
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitCase(CaseTree node, Void unused) {
        this.sync(node);
        this.markForPartialFormat();
        this.builder.forcedBreak();
        List<? extends CaseLabelTree> labels = node.getLabels();
        boolean isDefault = labels.size() == 1 && Iterables.getOnlyElement(labels).getKind().name().equals("DEFAULT_CASE_LABEL");
        this.builder.open(node.getCaseKind().equals((Object)CaseTree.CaseKind.RULE) && !node.getBody().getKind().equals((Object)Tree.Kind.BLOCK) ? this.plusFour : ZERO);
        if (isDefault) {
            this.token("default", ZERO);
        } else {
            Iterator iterator;
            this.token("case", ZERO);
            this.builder.open(labels.size() > 1 ? this.plusFour : ZERO);
            this.builder.space();
            boolean afterFirstToken = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Tree expression = (Tree)iterator.next();
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(expression, null);
                afterFirstToken = true;
            }
            this.builder.close();
        }
        ExpressionTree guard = this.getGuard(node);
        if (guard != null) {
            void var3_4;
            this.builder.space();
            this.token("when");
            this.builder.space();
            this.scan((Tree)var3_4, null);
        }
        switch (node.getCaseKind()) {
            case STATEMENT: {
                this.token(":");
                this.builder.open(this.plusTwo);
                this.visitStatements(node.getStatements());
                this.builder.close();
                break;
            }
            case RULE: {
                this.builder.space();
                this.token("-");
                this.token(">");
                if (node.getBody().getKind() == Tree.Kind.BLOCK) {
                    this.builder.space();
                    this.visitBlock((BlockTree)node.getBody(), JavaInputAstVisitor.CollapseEmptyOrNot.YES, JavaInputAstVisitor.AllowLeadingBlankLine.NO, JavaInputAstVisitor.AllowTrailingBlankLine.NO);
                } else {
                    this.builder.breakOp(" ");
                    this.scan(node.getBody(), null);
                }
                this.builder.guessToken(";");
                break;
            }
            default: {
                void var1_1;
                throw new AssertionError((Object)var1_1.getCaseKind());
            }
        }
        this.builder.close();
        return null;
    }

    protected ExpressionTree getGuard(CaseTree node) {
        return null;
    }
}

