/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.javadoc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.googlejavaformat.java.javadoc.NestingCounter;
import com.google.googlejavaformat.java.javadoc.Token;

final class JavadocWriter {
    private final int blockIndent;
    private final StringBuilder output = new StringBuilder();
    private boolean continuingListItemOfInnermostList;
    private boolean continuingFooterTag;
    private final NestingCounter continuingListItemCount = new NestingCounter();
    private final NestingCounter continuingListCount = new NestingCounter();
    private final NestingCounter postWriteModifiedContinuingListCount = new NestingCounter();
    private int remainingOnLine;
    private boolean atStartOfLine;
    private RequestedWhitespace requestedWhitespace = RequestedWhitespace.NONE;
    private Token requestedMoeBeginStripComment;
    private int indentForMoeEndStripComment;
    private boolean wroteAnythingSignificant;
    private static final ImmutableSet<Token.Type> START_OF_LINE_TOKENS = Sets.immutableEnumSet$76e8e224((Token.Type)Token.Type.LIST_ITEM_OPEN_TAG, (Token.Type[])new Token.Type[]{Token.Type.PARAGRAPH_OPEN_TAG, Token.Type.HEADER_OPEN_TAG});

    /*
     * WARNING - void declaration
     */
    JavadocWriter(int blockIndent) {
        void var1_1;
        this.blockIndent = var1_1;
    }

    final void requestWhitespace() {
        this.requestWhitespace(RequestedWhitespace.WHITESPACE);
    }

    /*
     * WARNING - void declaration
     */
    final void requestMoeBeginStripComment(Token token) {
        void var1_1;
        this.requestedMoeBeginStripComment = (Token)Preconditions.checkNotNull(var1_1);
    }

    final void writeBeginJavadoc() {
        this.output.append("/**");
        this.writeNewline();
    }

    final void writeEndJavadoc() {
        this.output.append("\n");
        JavadocWriter javadocWriter = this;
        javadocWriter.appendSpaces(javadocWriter.blockIndent + 1);
        this.output.append("*/");
    }

    /*
     * WARNING - void declaration
     */
    final void writeFooterJavadocTagStart(Token token) {
        void var1_1;
        this.continuingListItemOfInnermostList = false;
        this.continuingListItemCount.reset();
        this.continuingListCount.reset();
        this.postWriteModifiedContinuingListCount.reset();
        if (this.wroteAnythingSignificant) {
            if (!this.continuingFooterTag) {
                this.requestBlankLine();
            } else {
                this.continuingFooterTag = false;
                this.requestNewline();
            }
        }
        this.writeToken((Token)var1_1);
        this.continuingFooterTag = true;
    }

    /*
     * WARNING - void declaration
     */
    final void writeListOpen(Token token) {
        void var1_1;
        this.requestBlankLine();
        this.writeToken((Token)var1_1);
        this.continuingListItemOfInnermostList = false;
        this.continuingListCount.increment();
        this.postWriteModifiedContinuingListCount.increment();
        this.requestNewline();
    }

    /*
     * WARNING - void declaration
     */
    final void writeListClose(Token token) {
        void var1_1;
        this.requestNewline();
        this.continuingListItemCount.decrementIfPositive();
        this.continuingListCount.decrementIfPositive();
        this.writeToken((Token)var1_1);
        this.postWriteModifiedContinuingListCount.decrementIfPositive();
        this.requestBlankLine();
    }

    /*
     * WARNING - void declaration
     */
    final void writeListItemOpen(Token token) {
        void var1_1;
        this.requestNewline();
        if (this.continuingListItemOfInnermostList) {
            this.continuingListItemOfInnermostList = false;
            this.continuingListItemCount.decrementIfPositive();
        }
        this.writeToken((Token)var1_1);
        this.continuingListItemOfInnermostList = true;
        this.continuingListItemCount.increment();
    }

    /*
     * WARNING - void declaration
     */
    final void writeHeaderOpen(Token token) {
        void var1_1;
        this.requestBlankLine();
        this.writeToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writeHeaderClose(Token token) {
        void var1_1;
        this.writeToken((Token)var1_1);
        this.requestBlankLine();
    }

    /*
     * WARNING - void declaration
     */
    final void writeParagraphOpen(Token token) {
        void var1_1;
        if (!this.wroteAnythingSignificant) {
            return;
        }
        this.requestBlankLine();
        this.writeToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writeBlockquoteOpenOrClose(Token token) {
        void var1_1;
        this.requestBlankLine();
        this.writeToken((Token)var1_1);
        this.requestBlankLine();
    }

    /*
     * WARNING - void declaration
     */
    final void writePreOpen(Token token) {
        void var1_1;
        this.requestBlankLine();
        this.writeToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writePreClose(Token token) {
        void var1_1;
        this.writeToken((Token)var1_1);
        this.requestBlankLine();
    }

    /*
     * WARNING - void declaration
     */
    final void writeCodeOpen(Token token) {
        void var1_1;
        this.writeToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writeCodeClose(Token token) {
        void var1_1;
        this.writeToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writeTableOpen(Token token) {
        void var1_1;
        this.requestBlankLine();
        this.writeToken((Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writeTableClose(Token token) {
        void var1_1;
        this.writeToken((Token)var1_1);
        this.requestBlankLine();
    }

    /*
     * WARNING - void declaration
     */
    final void writeMoeEndStripComment(Token token) {
        void var1_1;
        this.writeLineBreakNoAutoIndent();
        JavadocWriter javadocWriter = this;
        javadocWriter.appendSpaces(javadocWriter.indentForMoeEndStripComment);
        this.writeToken((Token)var1_1);
        this.requestNewline();
    }

    /*
     * WARNING - void declaration
     */
    final void writeHtmlComment(Token token) {
        void var1_1;
        this.requestNewline();
        this.writeToken((Token)var1_1);
        this.requestNewline();
    }

    /*
     * WARNING - void declaration
     */
    final void writeBr(Token token) {
        void var1_1;
        this.writeToken((Token)var1_1);
        this.requestNewline();
    }

    final void writeLineBreakNoAutoIndent() {
        this.writeNewline(AutoIndent.NO_AUTO_INDENT);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLiteral(Token token) {
        void var1_1;
        this.writeToken((Token)var1_1);
    }

    public final String toString() {
        return this.output.toString();
    }

    private void requestBlankLine() {
        this.requestWhitespace(RequestedWhitespace.BLANK_LINE);
    }

    private void requestNewline() {
        this.requestWhitespace(RequestedWhitespace.NEWLINE);
    }

    /*
     * WARNING - void declaration
     */
    private void requestWhitespace(RequestedWhitespace requestedWhitespace) {
        void var1_1;
        RequestedWhitespace requestedWhitespace2 = this.requestedWhitespace;
        this.requestedWhitespace = var1_1.compareTo(requestedWhitespace2) >= 0 ? var1_1 : requestedWhitespace2;
    }

    /*
     * WARNING - void declaration
     */
    private void writeToken(Token token) {
        void var1_1;
        while (true) {
            void var2_2;
            boolean needWhitespace;
            if (this.requestedMoeBeginStripComment != null) {
                this.requestNewline();
            }
            if (this.requestedWhitespace == RequestedWhitespace.BLANK_LINE && (this.postWriteModifiedContinuingListCount.isPositive() || this.continuingFooterTag)) {
                this.requestedWhitespace = RequestedWhitespace.NEWLINE;
            }
            if (this.requestedWhitespace == RequestedWhitespace.BLANK_LINE) {
                this.writeBlankLine();
                this.requestedWhitespace = RequestedWhitespace.NONE;
            } else if (this.requestedWhitespace == RequestedWhitespace.NEWLINE) {
                this.writeNewline();
                this.requestedWhitespace = RequestedWhitespace.NONE;
            }
            boolean bl = needWhitespace = this.requestedWhitespace == RequestedWhitespace.WHITESPACE;
            if (!this.atStartOfLine && token.length() + (needWhitespace ? 1 : 0) > this.remainingOnLine) {
                this.writeNewline();
            }
            if (!this.atStartOfLine && var2_2 != false) {
                this.output.append(" ");
                --this.remainingOnLine;
            }
            if (this.requestedMoeBeginStripComment == null) break;
            this.output.append(this.requestedMoeBeginStripComment.getValue());
            this.requestedMoeBeginStripComment = null;
            this.indentForMoeEndStripComment = this.innerIndent();
            this.requestNewline();
        }
        this.output.append(token.getValue());
        if (!START_OF_LINE_TOKENS.contains((Object)token.getType())) {
            this.atStartOfLine = false;
        }
        this.remainingOnLine -= var1_1.length();
        this.requestedWhitespace = RequestedWhitespace.NONE;
        this.wroteAnythingSignificant = true;
    }

    private void writeBlankLine() {
        this.output.append("\n");
        JavadocWriter javadocWriter = this;
        javadocWriter.appendSpaces(javadocWriter.blockIndent + 1);
        this.output.append("*");
        this.writeNewline();
    }

    private void writeNewline() {
        this.writeNewline(AutoIndent.AUTO_INDENT);
    }

    /*
     * WARNING - void declaration
     */
    private void writeNewline(AutoIndent autoIndent) {
        void var1_1;
        this.output.append("\n");
        JavadocWriter javadocWriter = this;
        javadocWriter.appendSpaces(javadocWriter.blockIndent + 1);
        this.output.append("*");
        this.appendSpaces(1);
        this.remainingOnLine = 100 - this.blockIndent - 3;
        if (var1_1 == AutoIndent.AUTO_INDENT) {
            JavadocWriter javadocWriter2 = this;
            javadocWriter2.appendSpaces(javadocWriter2.innerIndent());
            this.remainingOnLine -= this.innerIndent();
        }
        this.atStartOfLine = true;
    }

    /*
     * WARNING - void declaration
     */
    private int innerIndent() {
        void var1_1;
        int innerIndent = (this.continuingListItemCount.value() << 2) + (this.continuingListCount.value() << 1);
        if (this.continuingFooterTag) {
            innerIndent += 4;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void appendSpaces(int count) {
        void var1_1;
        this.output.append(" ".repeat((int)var1_1));
    }

    static enum RequestedWhitespace {
        NONE,
        WHITESPACE,
        NEWLINE,
        BLANK_LINE;

    }

    static enum AutoIndent {
        AUTO_INDENT,
        NO_AUTO_INDENT;

    }
}

