/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Android;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.RopeByteString;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public abstract class ByteString
implements Serializable,
Iterable<Byte> {
    public static final LiteralByteString EMPTY$6bb3303a = new LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
    private static final ByteArrayCopier byteArrayCopier = Android.isOnAndroidDevice() ? new SystemByteArrayCopier(0) : new ArraysByteArrayCopier(0);
    private int hash = 0;
    private static final Comparator<ByteString> UNSIGNED_LEXICOGRAPHICAL_COMPARATOR$3706e907 = new Comparator<ByteString>(){};

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    public AbstractByteIterator iterator$10a6595f() {
        return new AbstractByteIterator(this){
            private int position = 0;
            private final int limit = this.this$0.size();
            private /* synthetic */ ByteString this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public final boolean hasNext() {
                return this.position < this.limit;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final byte nextByte() {
                void var1_1;
                int currentPos = this.position;
                if (currentPos >= this.limit) {
                    throw new NoSuchElementException();
                }
                this.position = currentPos + 1;
                return this.this$0.internalByteAt((int)var1_1);
            }
        };
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public static Comparator<ByteString> unsignedLexicographicalComparator() {
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR$3706e907;
    }

    public abstract ByteString substring(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    public static LiteralByteString copyFrom$7efb1774(byte[] bytes, int offset, int size) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        int n = offset;
        ByteString.checkRange(n, n + size, bytes.length);
        return new LiteralByteString(byteArrayCopier.copyFrom(byArray, (int)var1_1, (int)var2_2));
    }

    public static ByteString copyFrom(byte[] bytes) {
        byte[] byArray;
        return ByteString.copyFrom$7efb1774(bytes, 0, byArray.length);
    }

    static LiteralByteString wrap$e5dd4d4(byte[] bytes) {
        byte[] byArray;
        return new LiteralByteString(byArray);
    }

    public static LiteralByteString copyFromUtf8$6a838971(String text) {
        String string;
        return new LiteralByteString(string.getBytes(Internal.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    public final ByteString concat(ByteString other) {
        void var1_1;
        if (Integer.MAX_VALUE - this.size() < other.size()) {
            throw new IllegalArgumentException("ByteString would be too long: " + this.size() + "+" + other.size());
        }
        return RopeByteString.concatenate(this, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void copyTo(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        int n = sourceOffset;
        ByteString.checkRange(n, n + numberToCopy, this.size());
        int n2 = targetOffset;
        ByteString.checkRange(n2, n2 + numberToCopy, target.length);
        if (numberToCopy > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.copyToInternal((byte[])var1_1, (int)var2_2, (int)var3_3, numberToCopy);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var2_2;
        void var1_1;
        int size = this.size();
        if (size == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        this.copyToInternal(result, 0, 0, (int)var1_1);
        return var2_2;
    }

    abstract void writeTo(ByteOutput var1) throws IOException;

    public abstract ByteBuffer asReadOnlyByteBuffer();

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        Charset charset = Internal.UTF_8;
        ByteString byteString = this;
        if (byteString.size() == 0) {
            return "";
        }
        return byteString.toStringInternal(charset);
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        int n;
        int h = this.hash;
        if (h == 0) {
            int size = this.size();
            n = this.partialHash(size, 0, n);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    static CodedBuilder newCodedBuilder(int size) {
        int n;
        return new CodedBuilder(n, 0);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    /*
     * WARNING - void declaration
     */
    static void checkIndex(int index, int size) {
        if ((index | size - (index + 1)) < 0) {
            void var1_1;
            int n;
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException("Index < 0: " + index);
            }
            throw new ArrayIndexOutOfBoundsException("Index > length: " + n + ", " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static int checkRange(int startIndex, int endIndex, int size) {
        void var3_3;
        int length = endIndex - startIndex;
        if ((startIndex | endIndex | length | size - endIndex) < 0) {
            void var2_2;
            void var1_1;
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("Beginning index: " + startIndex + " < 0");
            }
            if (endIndex < startIndex) {
                int n;
                throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + n + ", " + endIndex);
            }
            throw new IndexOutOfBoundsException("End index: " + (int)var1_1 + " >= " + (int)var2_2);
        }
        return (int)var3_3;
    }

    public final String toString() {
        ByteString byteString;
        return String.format(Locale.ROOT, "<ByteString@%s size=%d contents=\"%s\">", Integer.toHexString(System.identityHashCode(this)), this.size(), (byteString = this).size() <= 50 ? TextFormatEscaper.escapeBytes(byteString) : TextFormatEscaper.escapeBytes(byteString.substring(0, 47)) + "...");
    }

    static /* synthetic */ int access$200(byte x0) {
        byte by = x0;
        return by & 0xFF;
    }

    private static final class BoundedByteString
    extends LiteralByteString {
        private final int bytesOffset;
        private final int bytesLength;

        /*
         * WARNING - void declaration
         */
        BoundedByteString(byte[] bytes, int offset, int length) {
            super(bytes);
            void var3_3;
            void var2_2;
            void var1_1;
            int n = offset;
            BoundedByteString.checkRange(n, n + length, ((void)var1_1).length);
            this.bytesOffset = var2_2;
            this.bytesLength = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte byteAt(int index) {
            void var1_1;
            BoundedByteString boundedByteString = this;
            BoundedByteString.checkIndex(index, boundedByteString.bytesLength);
            return this.bytes[this.bytesOffset + var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final byte internalByteAt(int index) {
            void var1_1;
            return this.bytes[this.bytesOffset + var1_1];
        }

        @Override
        public final int size() {
            return this.bytesLength;
        }

        @Override
        protected final int getOffsetIntoBytes() {
            return this.bytesOffset;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            void var3_3;
            void var1_1;
            void var2_2;
            BoundedByteString boundedByteString = this;
            System.arraycopy(this.bytes, boundedByteString.bytesOffset + var2_2, var1_1, (int)var3_3, numberToCopy);
        }
    }

    private static class LiteralByteString
    extends LeafByteString {
        protected final byte[] bytes;

        /*
         * WARNING - void declaration
         */
        LiteralByteString(byte[] bytes) {
            void var1_1;
            if (bytes == null) {
                throw new NullPointerException();
            }
            this.bytes = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte byteAt(int index) {
            void var1_1;
            return this.bytes[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        byte internalByteAt(int index) {
            void var1_1;
            return this.bytes[var1_1];
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString substring(int beginIndex, int endIndex) {
            void var2_2;
            void var1_1;
            int length = LiteralByteString.checkRange(beginIndex, endIndex, ((ByteString)this).size());
            if (length == 0) {
                return EMPTY$6bb3303a;
            }
            return new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            void var3_3;
            void var1_1;
            void var2_2;
            System.arraycopy(this.bytes, (int)var2_2, var1_1, (int)var3_3, numberToCopy);
        }

        @Override
        public final ByteBuffer asReadOnlyByteBuffer() {
            return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size()).asReadOnlyBuffer();
        }

        @Override
        final void writeTo(ByteOutput output) throws IOException {
            output.writeLazy(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String toStringInternal(Charset charset) {
            void var1_1;
            return new String(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size(), (Charset)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isValidUtf8() {
            void var1_1;
            int offset = this.getOffsetIntoBytes();
            void v0 = var1_1;
            return Utf8.isValidUtf8(this.bytes, (int)v0, (int)(v0 + ((ByteString)this).size()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int partialIsValidUtf8(int state, int offset, int length) {
            void var3_3;
            void var1_1;
            void var2_2;
            int index = this.getOffsetIntoBytes() + offset;
            void v0 = var2_2;
            return Utf8.partialIsValidUtf8((int)var1_1, this.bytes, (int)v0, (int)(v0 + var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            if (other == this) {
                return true;
            }
            if (!(other instanceof ByteString)) {
                return false;
            }
            if (((ByteString)this).size() != ((ByteString)other).size()) {
                return false;
            }
            if (((ByteString)this).size() == 0) {
                return true;
            }
            if (other instanceof LiteralByteString) {
                void var2_3;
                void var3_4;
                LiteralByteString otherAsLiteral = (LiteralByteString)other;
                int thisHash = this.peekCachedHashCode();
                int thatHash = otherAsLiteral.peekCachedHashCode();
                if (thisHash != 0 && thatHash != 0 && var3_4 != var2_3) {
                    return false;
                }
                return this.equalsRange$1427d5d3((LiteralByteString)other, 0, ((ByteString)this).size());
            }
            return var1_1.equals(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean equalsRange$1427d5d3(LeafByteString other, int offset, int length) {
            void var3_4;
            void var1_1;
            void var2_3;
            if (length > other.size()) {
                throw new IllegalArgumentException("Length too large: " + length + ((ByteString)this).size());
            }
            if (offset + length > other.size()) {
                throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
            }
            if (other instanceof LiteralByteString) {
                LiteralByteString lbsOther = (LiteralByteString)other;
                byte[] thisBytes = this.bytes;
                byte[] otherBytes = lbsOther.bytes;
                int thisLimit = this.getOffsetIntoBytes() + length;
                int thisIndex = this.getOffsetIntoBytes();
                int otherIndex = lbsOther.getOffsetIntoBytes() + offset;
                while (thisIndex < thisLimit) {
                    if (thisBytes[thisIndex] != otherBytes[otherIndex]) {
                        return false;
                    }
                    ++thisIndex;
                    ++otherIndex;
                }
                return true;
            }
            void v0 = var2_3;
            return var1_1.substring((int)v0, (int)(v0 + var3_4)).equals(((ByteString)this).substring(0, (int)var3_4));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int partialHash(int h, int offset, int length) {
            void var3_3;
            void var2_2;
            return Internal.partialHash(h, this.bytes, this.getOffsetIntoBytes() + var2_2, (int)var3_3);
        }

        @Override
        public final InputStream newInput() {
            return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size());
        }

        @Override
        public final CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance$35ce18fe(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size(), true);
        }

        protected int getOffsetIntoBytes() {
            return 0;
        }
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        /*
         * WARNING - void declaration
         */
        private CodedBuilder(int size) {
            void var1_1;
            this.buffer = new byte[var1_1];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public final LiteralByteString build$2036f13b() {
            CodedOutputStream codedOutputStream = this.output;
            if (codedOutputStream.spaceLeft() != 0) {
                throw new IllegalStateException("Did not write as much data as expected.");
            }
            return new LiteralByteString(this.buffer);
        }

        public final CodedOutputStream getCodedOutput() {
            return this.output;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ CodedBuilder(int x0, byte by) {
            this((int)var1_1);
            void var1_1;
        }
    }

    static abstract class LeafByteString
    extends ByteString {
        LeafByteString() {
        }

        @Override
        protected final int getTreeDepth() {
            return 0;
        }

        @Override
        protected final boolean isBalanced() {
            return true;
        }

        abstract boolean equalsRange$1427d5d3(LeafByteString var1, int var2, int var3);
    }

    static abstract class AbstractByteIterator
    implements ByteIterator {
        AbstractByteIterator() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }

    private static final class ArraysByteArrayCopier
    implements ByteArrayCopier {
        private ArraysByteArrayCopier() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            void var3_3;
            void var2_2;
            void v0 = var2_2;
            return Arrays.copyOfRange(bytes, (int)v0, (int)(v0 + var3_3));
        }

        /* synthetic */ ArraysByteArrayCopier(byte by) {
            this();
        }
    }

    private static final class SystemByteArrayCopier
    implements ByteArrayCopier {
        private SystemByteArrayCopier() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            void var3_3;
            void var2_2;
            void var1_1;
            byte[] copy = new byte[size];
            System.arraycopy(var1_1, (int)var2_2, copy, 0, (int)var3_3);
            return copy;
        }

        /* synthetic */ SystemByteArrayCopier(byte by) {
            this();
        }
    }

    private static interface ByteArrayCopier {
        public byte[] copyFrom(byte[] var1, int var2, int var3);
    }
}

