/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.UnmodifiableLazyStringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList(false);
    private final List<Object> list;

    public static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    private LazyStringArrayList(boolean isMutable) {
        super(false);
        this.list = Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList(int initialCapacity) {
        this(new ArrayList<Object>((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList(LazyStringArrayList from) {
        void var1_1;
        this.list = new ArrayList<Object>(from.size());
        this.addAll((Collection<? extends String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private LazyStringArrayList(ArrayList<Object> list2) {
        void var1_1;
        this.list = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String get(int index) {
        void var3_4;
        void var2_2;
        ByteString bs;
        Object o = this.list.get(index);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            bs = (ByteString)o;
            String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
                this.list.set(index, s);
            }
            return s;
        }
        byte[] ba = (byte[])bs;
        String s = Internal.toStringUtf8(ba);
        if (Internal.isValidUtf8((byte[])var2_2)) {
            void var1_1;
            this.list.set((int)var1_1, s);
        }
        return var3_4;
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends String> c) {
        void var1_1;
        LazyStringArrayList lazyStringArrayList = this;
        return lazyStringArrayList.addAll(lazyStringArrayList.size(), (Collection<? extends String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends String> c) {
        void var1_1;
        void var2_2;
        void collection;
        this.ensureIsMutable();
        collection = c instanceof LazyStringList ? ((LazyStringList)c).getUnderlyingElements() : collection;
        boolean ret = this.list.addAll(index, (Collection<Object>)var2_2);
        ++this.modCount;
        return (boolean)var1_1;
    }

    @Override
    public final void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(ByteString element) {
        void var1_1;
        this.ensureIsMutable();
        this.list.add(var1_1);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getRaw(int index) {
        void var1_1;
        return this.list.get((int)var1_1);
    }

    private static String asString(Object o) {
        Object object;
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            return ((ByteString)o).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    @Override
    public final List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public final LazyStringList getUnmodifiableView() {
        LazyStringArrayList lazyStringArrayList = this;
        if (super.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }
}

