/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class RopeByteString
extends ByteString {
    static final int[] minLengthByDepth = new int[]{1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170, 1836311903, Integer.MAX_VALUE};
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;

    /*
     * WARNING - void declaration
     */
    private RopeByteString(ByteString left, ByteString right) {
        void var2_2;
        void var1_1;
        this.left = left;
        this.right = right;
        this.leftLength = left.size();
        this.totalLength = this.leftLength + right.size();
        this.treeDepth = Math.max(var1_1.getTreeDepth(), var2_2.getTreeDepth()) + 1;
    }

    /*
     * WARNING - void declaration
     */
    static ByteString concatenate(ByteString left, ByteString right) {
        void var1_1;
        void var3_4;
        void var2_2;
        ByteString byteString;
        if (right.size() == 0) {
            return left;
        }
        if (left.size() == 0) {
            return right;
        }
        int newLength = left.size() + right.size();
        if (newLength < 128) {
            return RopeByteString.concatenateBytes(left, right);
        }
        if (left instanceof RopeByteString) {
            ByteString newRight;
            RopeByteString leftRope = (RopeByteString)left;
            if (leftRope.right.size() + right.size() < 128) {
                newRight = RopeByteString.concatenateBytes(leftRope.right, right);
                return new RopeByteString(leftRope.left, newRight);
            }
            if (leftRope.left.getTreeDepth() > leftRope.right.getTreeDepth()) {
                RopeByteString ropeByteString = leftRope;
                if (ropeByteString.treeDepth > right.getTreeDepth()) {
                    newRight = new RopeByteString(leftRope.right, right);
                    return new RopeByteString(leftRope.left, byteString);
                }
            }
        }
        int newDepth = Math.max(byteString.getTreeDepth(), right.getTreeDepth()) + 1;
        if (var2_2 >= RopeByteString.minLength((int)var3_4)) {
            return new RopeByteString(byteString, right);
        }
        return Balancer.access$100(new Balancer(0), byteString, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteString concatenateBytes(ByteString left, ByteString right) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteString byteString;
        int leftSize = left.size();
        int rightSize = right.size();
        byte[] bytes = new byte[leftSize + rightSize];
        byteString.copyTo(bytes, 0, 0, leftSize);
        var1_1.copyTo(bytes, 0, (int)var2_2, (int)var3_3);
        return ByteString.wrap$e5dd4d4(bytes);
    }

    static int minLength(int depth) {
        int n;
        if (depth >= minLengthByDepth.length) {
            return Integer.MAX_VALUE;
        }
        return minLengthByDepth[n];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte byteAt(int index) {
        void var1_1;
        RopeByteString.checkIndex(index, this.totalLength);
        return this.internalByteAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final byte internalByteAt(int index) {
        void var1_1;
        if (index < this.leftLength) {
            return this.left.internalByteAt(index);
        }
        return this.right.internalByteAt((int)(var1_1 - this.leftLength));
    }

    @Override
    public final int size() {
        return this.totalLength;
    }

    @Override
    public final ByteString.AbstractByteIterator iterator$10a6595f() {
        return new ByteString.AbstractByteIterator(this){
            private PieceIterator pieces;
            private ByteString.ByteIterator current;
            private /* synthetic */ RopeByteString this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.pieces = new PieceIterator(this.this$0, 0);
                this.current = this.nextPiece();
            }

            private ByteString.ByteIterator nextPiece() {
                if (this.pieces.hasNext()) {
                    return this.pieces.next().iterator$10a6595f();
                }
                return null;
            }

            @Override
            public final boolean hasNext() {
                return this.current != null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final byte nextByte() {
                void var1_1;
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                byte b = this.current.nextByte();
                if (!this.current.hasNext()) {
                    this.current = this.nextPiece();
                }
                return (byte)var1_1;
            }
        };
    }

    @Override
    protected final int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected final boolean isBalanced() {
        return this.totalLength >= RopeByteString.minLength(this.treeDepth);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString substring(int beginIndex2, int endIndex) {
        void var2_4;
        void var1_2;
        int n;
        int length = RopeByteString.checkRange(beginIndex2, endIndex, this.totalLength);
        if (length == 0) {
            return ByteString.EMPTY$6bb3303a;
        }
        if (n == this.totalLength) {
            return this;
        }
        if (endIndex <= this.leftLength) {
            return this.left.substring(beginIndex2, endIndex);
        }
        if (beginIndex2 >= this.leftLength) {
            return this.right.substring(beginIndex2 - this.leftLength, endIndex - this.leftLength);
        }
        n = beginIndex2;
        ByteString beginIndex2 = this.left;
        ByteString leftSub = beginIndex2.substring(n, beginIndex2.size());
        ByteString rightSub = this.right.substring(0, endIndex - this.leftLength);
        return new RopeByteString((ByteString)var1_2, (ByteString)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (sourceOffset + numberToCopy <= this.leftLength) {
            this.left.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
            return;
        }
        if (sourceOffset >= this.leftLength) {
            this.right.copyToInternal(target, sourceOffset - this.leftLength, targetOffset, numberToCopy);
            return;
        }
        int leftLength = this.leftLength - sourceOffset;
        this.left.copyToInternal(target, (int)var2_2, targetOffset, leftLength);
        this.right.copyToInternal((byte[])var1_1, 0, (int)(var3_3 + leftLength), numberToCopy - leftLength);
    }

    @Override
    public final ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void writeTo(ByteOutput output) throws IOException {
        void var1_1;
        this.left.writeTo(output);
        this.right.writeTo((ByteOutput)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final String toStringInternal(Charset charset) {
        void var1_1;
        return new String(this.toByteArray(), (Charset)var1_1);
    }

    @Override
    public final boolean isValidUtf8() {
        int n;
        int leftPartial = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        return (n = this.right.partialIsValidUtf8(n, 0, this.right.size())) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int partialIsValidUtf8(int state, int offset, int length) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = offset + length;
        if (n <= this.leftLength) {
            return this.left.partialIsValidUtf8(state, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialIsValidUtf8(state, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialIsValidUtf8(state, (int)var2_2, leftLength);
        return this.right.partialIsValidUtf8((int)var1_1, 0, (int)(var3_3 - leftLength));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        RopeByteString ropeByteString;
        int n;
        void var2_2;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString otherByteString = (ByteString)other;
        if (this.totalLength != otherByteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        int thisHash = this.peekCachedHashCode();
        int thatHash = otherByteString.peekCachedHashCode();
        if (thisHash != 0 && thatHash != 0 && var2_2 != n) {
            return false;
        }
        PieceIterator pieceIterator = ropeByteString;
        ropeByteString = this;
        n = 0;
        PieceIterator pieceIterator2 = new PieceIterator(ropeByteString, 0);
        ByteString.LeafByteString leafByteString = (ByteString.LeafByteString)pieceIterator2.next();
        int n2 = 0;
        pieceIterator = new PieceIterator((ByteString)((Object)pieceIterator), 0);
        ByteString.LeafByteString leafByteString2 = (ByteString.LeafByteString)pieceIterator.next();
        int n3 = 0;
        while (true) {
            int n4 = leafByteString.size() - n;
            int n5 = leafByteString2.size() - n2;
            int n6 = Math.min(n4, n5);
            boolean bl = n == 0 ? leafByteString.equalsRange$1427d5d3(leafByteString2, n2, n6) : leafByteString2.equalsRange$1427d5d3(leafByteString, n, n6);
            if (!bl) {
                return false;
            }
            if ((n3 += n6) >= ropeByteString.totalLength) {
                if (n3 == ropeByteString.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n6 == n4) {
                n = 0;
                leafByteString = (ByteString.LeafByteString)pieceIterator2.next();
            } else {
                n += n6;
            }
            if (n6 == n5) {
                n2 = 0;
                leafByteString2 = (ByteString.LeafByteString)pieceIterator.next();
                continue;
            }
            n2 += n6;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int partialHash(int h, int offset, int length) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = offset + length;
        if (n <= this.leftLength) {
            return this.left.partialHash(h, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialHash(h, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialHash(h, (int)var2_2, leftLength);
        return this.right.partialHash((int)var1_1, 0, (int)(var3_3 - leftLength));
    }

    @Override
    public final CodedInputStream newCodedInput() {
        Object object = this;
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        object = new PieceIterator((ByteString)object, 0);
        while (((PieceIterator)object).hasNext()) {
            ByteString.LeafByteString leafByteString = ((PieceIterator)object).next();
            arrayList.add(leafByteString.asReadOnlyByteBuffer());
        }
        return CodedInputStream.newInstance(arrayList, true);
    }

    @Override
    public final InputStream newInput() {
        return new RopeInputStream(this);
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ RopeByteString(ByteString x0, ByteString x1, byte by) {
        this((ByteString)var1_1, (ByteString)var2_2);
        void var2_2;
        void var1_1;
    }

    private final class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private ByteString.LeafByteString currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;
        private /* synthetic */ RopeByteString this$0;

        public RopeInputStream(RopeByteString ropeByteString) {
            this.this$0 = ropeByteString;
            this.initialize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int read(byte[] b, int offset, int length) {
            void var1_2;
            void var3_4;
            void var2_3;
            if (b == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || length > b.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            int bytesRead = this.readSkipInternal(b, (int)var2_3, length);
            if (bytesRead == 0 && (var3_4 > 0 || this.availableInternal() == 0)) {
                return -1;
            }
            return (int)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long skip(long length) {
            void var1_1;
            if (length < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (length > Integer.MAX_VALUE) {
                length = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private int readSkipInternal(byte[] b, int offset, int length) {
            void var3_3;
            int bytesRemaining;
            int count;
            for (bytesRemaining = length; bytesRemaining > 0; bytesRemaining -= count) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) break;
                int n = this.currentPieceSize - this.currentPieceIndex;
                count = Math.min(n, bytesRemaining);
                if (b != null) {
                    this.currentPiece.copyTo(b, this.currentPieceIndex, offset, count);
                    offset += count;
                }
                this.currentPieceIndex += count;
            }
            return (int)(var3_3 - bytesRemaining);
        }

        @Override
        public final int read() throws IOException {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        @Override
        public final int available() throws IOException {
            return this.availableInternal();
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final void mark(int readAheadLimit) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public final synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(this.this$0, 0);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = this.currentPiece.size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = this.currentPiece.size();
                    return;
                }
                this.currentPiece = null;
                this.currentPieceSize = 0;
            }
        }

        /*
         * WARNING - void declaration
         */
        private int availableInternal() {
            void var1_1;
            int bytesRead = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return ((ByteString)this.this$0).size() - var1_1;
        }
    }

    private static final class PieceIterator
    implements Iterator<ByteString.LeafByteString> {
        private final ArrayDeque<RopeByteString> breadCrumbs;
        private ByteString.LeafByteString next;

        /*
         * WARNING - void declaration
         */
        private PieceIterator(ByteString root) {
            void var1_1;
            if (root instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)root;
                this.breadCrumbs = new ArrayDeque(rbs.getTreeDepth());
                this.breadCrumbs.push(rbs);
                this.next = this.getLeafByLeft(((RopeByteString)var1_1).left);
                return;
            }
            this.breadCrumbs = null;
            this.next = (ByteString.LeafByteString)var1_1;
        }

        private ByteString.LeafByteString getLeafByLeft(ByteString root) {
            ByteString byteString;
            ByteString pos = root;
            while (pos instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)pos;
                this.breadCrumbs.push(rbs);
                byteString = ((RopeByteString)byteString).left;
            }
            return (ByteString.LeafByteString)byteString;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString.LeafByteString next() {
            void var1_1;
            ByteString.LeafByteString leafByteString;
            block3: {
                PieceIterator pieceIterator;
                ByteString.LeafByteString leafByteString2;
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                ByteString.LeafByteString result = this.next;
                PieceIterator pieceIterator2 = this;
                do {
                    if (pieceIterator2.breadCrumbs == null || pieceIterator2.breadCrumbs.isEmpty()) {
                        leafByteString = null;
                        break block3;
                    }
                    pieceIterator = pieceIterator2;
                } while ((leafByteString2 = pieceIterator.getLeafByLeft(pieceIterator.breadCrumbs.pop().right)).isEmpty());
                leafByteString = leafByteString2;
            }
            this.next = leafByteString;
            return var1_1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ PieceIterator(ByteString x0, byte by) {
            this((ByteString)var1_1);
            void var1_1;
        }
    }

    private static final class Balancer {
        private final ArrayDeque<ByteString> prefixesStack = new ArrayDeque();

        private Balancer() {
        }

        /*
         * WARNING - void declaration
         */
        private void doBalance(ByteString root) {
            void var1_1;
            if (root.isBalanced()) {
                this.insert(root);
                return;
            }
            if (root instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)root;
                this.doBalance(rbs.left);
                this.doBalance(((RopeByteString)var1_1).right);
                return;
            }
            throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + var1_1.getClass());
        }

        /*
         * WARNING - void declaration
         */
        private void insert(ByteString byteString) {
            void var1_1;
            int depthBin = Balancer.getDepthBinForLength(byteString.size());
            int binEnd = RopeByteString.minLength(depthBin + 1);
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= binEnd) {
                this.prefixesStack.push(byteString);
                return;
            }
            int binStart = RopeByteString.minLength(depthBin);
            ByteString newTree = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < binStart) {
                ByteString left = this.prefixesStack.pop();
                newTree = new RopeByteString(left, newTree, 0);
            }
            newTree = new RopeByteString(newTree, (ByteString)var1_1, 0);
            while (!this.prefixesStack.isEmpty()) {
                void var3_5;
                int n = Balancer.getDepthBinForLength(newTree.size());
                int left = RopeByteString.minLength(n + 1);
                if (this.prefixesStack.peek().size() >= left) break;
                ByteString left2 = this.prefixesStack.pop();
                newTree = new RopeByteString((ByteString)var3_5, newTree, 0);
            }
            this.prefixesStack.push(newTree);
        }

        private static int getDepthBinForLength(int length) {
            int n;
            int depth = Arrays.binarySearch(minLengthByDepth, length);
            if (depth < 0) {
                depth = -(depth + 1);
                --depth;
            }
            return n;
        }

        /* synthetic */ Balancer(byte by) {
            this();
        }

        static /* synthetic */ ByteString access$100(Balancer x0, ByteString x1, ByteString x2) {
            ByteString byteString;
            ByteString byteString2;
            Balancer balancer = x0;
            balancer.doBalance(byteString2);
            balancer.doBalance(byteString);
            byteString2 = balancer.prefixesStack.pop();
            while (!balancer.prefixesStack.isEmpty()) {
                byteString = balancer.prefixesStack.pop();
                byteString2 = new RopeByteString(byteString, byteString2, 0);
            }
            return byteString2;
        }
    }
}

