/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.TextFormatParseInfoTree;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());

    private TextFormat() {
    }

    public static Printer printer() {
        return Printer.DEFAULT;
    }

    public static String unsignedToString(int value) {
        int n;
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)n & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long value) {
        long l;
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(l & Long.MAX_VALUE).setBit(63).toString();
    }

    public static String escapeBytes(ByteString input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    public static String escapeBytes(byte[] input) {
        byte[] byArray = input;
        return TextFormatEscaper.escapeBytes(new TextFormatEscaper.ByteSequence(byArray){
            private /* synthetic */ byte[] val$input;
            {
                this.val$input = byArray;
            }

            public final int size() {
                return this.val$input.length;
            }

            /*
             * WARNING - void declaration
             */
            public final byte byteAt(int offset) {
                void var1_1;
                return this.val$input[var1_1];
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        void var2_2;
        void var1_1;
        ByteString.LiteralByteString input = ByteString.copyFromUtf8$6a838971(charString.toString());
        byte[] result = new byte[((ByteString)input).size()];
        int pos = 0;
        block16: for (int i = 0; i < ((ByteString)input).size(); ++i) {
            void var4_4;
            byte c = ((ByteString)input).byteAt(i);
            if (c == 92) {
                if (i + 1 < ((ByteString)input).size()) {
                    int code;
                    if (TextFormat.isOctal(c = ((ByteString)input).byteAt(++i))) {
                        code = TextFormat.digitValue(c);
                        if (i + 1 < ((ByteString)input).size() && TextFormat.isOctal(((ByteString)input).byteAt(i + 1))) {
                            code = (code << 3) + TextFormat.digitValue(((ByteString)input).byteAt(++i));
                        }
                        if (i + 1 < ((ByteString)input).size() && TextFormat.isOctal(((ByteString)input).byteAt(i + 1))) {
                            code = (code << 3) + TextFormat.digitValue(((ByteString)input).byteAt(++i));
                        }
                        result[pos++] = (byte)code;
                        continue;
                    }
                    switch (code) {
                        case 97: {
                            result[pos++] = 7;
                            continue block16;
                        }
                        case 98: {
                            result[pos++] = 8;
                            continue block16;
                        }
                        case 102: {
                            result[pos++] = 12;
                            continue block16;
                        }
                        case 110: {
                            result[pos++] = 10;
                            continue block16;
                        }
                        case 114: {
                            result[pos++] = 13;
                            continue block16;
                        }
                        case 116: {
                            result[pos++] = 9;
                            continue block16;
                        }
                        case 118: {
                            result[pos++] = 11;
                            continue block16;
                        }
                        case 92: {
                            result[pos++] = 92;
                            continue block16;
                        }
                        case 39: {
                            result[pos++] = 39;
                            continue block16;
                        }
                        case 34: {
                            result[pos++] = 34;
                            continue block16;
                        }
                        case 63: {
                            result[pos++] = 63;
                            continue block16;
                        }
                        case 120: {
                            if (i + 1 >= ((ByteString)input).size() || !TextFormat.isHex(((ByteString)input).byteAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(((ByteString)input).byteAt(++i));
                            if (i + 1 < ((ByteString)input).size() && TextFormat.isHex(((ByteString)input).byteAt(i + 1))) {
                                code = (code << 4) + TextFormat.digitValue(((ByteString)input).byteAt(++i));
                            }
                            result[pos++] = (byte)code;
                            continue block16;
                        }
                        case 117: {
                            if (++i + 3 < ((ByteString)input).size() && TextFormat.isHex(((ByteString)input).byteAt(i)) && TextFormat.isHex(((ByteString)input).byteAt(i + 1)) && TextFormat.isHex(((ByteString)input).byteAt(i + 2)) && TextFormat.isHex(((ByteString)input).byteAt(i + 3))) {
                                char ch = (char)(TextFormat.digitValue(((ByteString)input).byteAt(i)) << 12 | TextFormat.digitValue(((ByteString)input).byteAt(i + 1)) << 8 | TextFormat.digitValue(((ByteString)input).byteAt(i + 2)) << 4 | TextFormat.digitValue(((ByteString)input).byteAt(i + 3)));
                                if (ch >= '\ud800' && ch <= '\udfff') {
                                    throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\u' refers to a surrogate");
                                }
                                byte[] chUtf8 = Character.toString(ch).getBytes(Internal.UTF_8);
                                System.arraycopy(chUtf8, 0, result, pos, chUtf8.length);
                                pos += chUtf8.length;
                                i += 3;
                                continue block16;
                            }
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\u' with too few hex chars");
                        }
                        case 85: {
                            if (++i + 7 >= ((ByteString)input).size()) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U' with too few hex chars");
                            }
                            int codepoint = 0;
                            for (int offset = i; offset < i + 8; ++offset) {
                                byte b = ((ByteString)input).byteAt(offset);
                                if (!TextFormat.isHex(b)) {
                                    throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U' with too few hex chars");
                                }
                                codepoint = codepoint << 4 | TextFormat.digitValue(b);
                            }
                            if (!Character.isValidCodePoint(codepoint)) {
                                int n = i;
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U" + ((ByteString)input).substring(n, n + 8).toStringUtf8() + "' is not a valid code point value");
                            }
                            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codepoint);
                            if (unicodeBlock != null && (unicodeBlock.equals(Character.UnicodeBlock.LOW_SURROGATES) || unicodeBlock.equals(Character.UnicodeBlock.HIGH_SURROGATES) || unicodeBlock.equals(Character.UnicodeBlock.HIGH_PRIVATE_USE_SURROGATES))) {
                                int n = i;
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U" + ((ByteString)input).substring(n, n + 8).toStringUtf8() + "' refers to a surrogate code unit");
                            }
                            int[] nArray = new int[1];
                            int[] codepoints = nArray;
                            nArray[0] = codepoint;
                            byte[] chUtf8 = new String(codepoints, 0, 1).getBytes(Internal.UTF_8);
                            System.arraycopy(chUtf8, 0, result, pos, chUtf8.length);
                            pos += chUtf8.length;
                            i += 7;
                            continue block16;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)var4_4 + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result[pos++] = var4_4;
        }
        if (result.length == pos) {
            return ByteString.wrap$e5dd4d4(result);
        }
        return ByteString.copyFrom$7efb1774((byte[])var1_1, 0, (int)var2_2);
    }

    public static String escapeDoubleQuotesAndBackslashes(String input) {
        String string = input;
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static boolean isOctal(byte c) {
        byte by;
        return 48 <= c && by <= 55;
    }

    private static boolean isHex(byte c) {
        byte by;
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && by <= 70;
    }

    private static int digitValue(byte c) {
        byte by;
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return by - 65 + 10;
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        long result;
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", 0)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            void var3_4;
            void var1_1;
            void var2_2;
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (var2_2 == false) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (var1_1 != false) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                String string;
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + string);
            }
            result = var3_4.longValue();
        }
        return result;
    }

    static /* synthetic */ TextGenerator access$200(Appendable x0) {
        Appendable appendable = x0;
        return new TextGenerator(appendable, false, 0);
    }

    static {
        new Parser.Builder().build();
    }

    public static final class InvalidEscapeSequenceException
    extends IOException {
        /*
         * WARNING - void declaration
         */
        InvalidEscapeSequenceException(String description) {
            super((String)var1_1);
            void var1_1;
        }
    }

    public static final class Parser {
        private final TypeRegistry typeRegistry;
        private final boolean allowUnknownFields;
        private final boolean allowUnknownEnumValues;
        private final boolean allowUnknownExtensions;
        private final int singularOverwritePolicy$17960e22;
        private TextFormatParseInfoTree.Builder parseInfoTreeBuilder;
        private final int recursionLimit;

        /*
         * WARNING - void declaration
         */
        private Parser(TypeRegistry typeRegistry, boolean allowUnknownFields, boolean allowUnknownEnumValues, boolean allowUnknownExtensions, int singularOverwritePolicy, TextFormatParseInfoTree.Builder parseInfoTreeBuilder, int recursionLimit) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.typeRegistry = var1_1;
            this.allowUnknownFields = var2_2;
            this.allowUnknownEnumValues = var3_3;
            this.allowUnknownExtensions = allowUnknownExtensions;
            this.singularOverwritePolicy$17960e22 = singularOverwritePolicy;
            this.parseInfoTreeBuilder = parseInfoTreeBuilder;
            this.recursionLimit = recursionLimit;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Parser(TypeRegistry x0, boolean x1, boolean x2, boolean x3, int x4, TextFormatParseInfoTree.Builder x5, int x6, byte by) {
            this((TypeRegistry)var1_1, (boolean)var2_2, (boolean)var3_3, x3, x4, x5, x6);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public static final class Builder {
            private boolean allowUnknownFields = false;
            private boolean allowUnknownEnumValues = false;
            private boolean allowUnknownExtensions = false;
            private int singularOverwritePolicy$17960e22 = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES$17960e22;
            private TextFormatParseInfoTree.Builder parseInfoTreeBuilder = null;
            private TypeRegistry typeRegistry = TypeRegistry.getEmptyTypeRegistry();
            private int recursionLimit = 100;

            public final Parser build() {
                return new Parser(this.typeRegistry, this.allowUnknownFields, this.allowUnknownEnumValues, this.allowUnknownExtensions, this.singularOverwritePolicy$17960e22, this.parseInfoTreeBuilder, this.recursionLimit, 0);
            }
        }

        public static final class SingularOverwritePolicy
        extends Enum<SingularOverwritePolicy> {
            public static final int ALLOW_SINGULAR_OVERWRITES$17960e22 = 1;
            private static int FORBID_SINGULAR_OVERWRITES$17960e22 = 2;

            static {
                int[] nArray = new int[]{ALLOW_SINGULAR_OVERWRITES$17960e22, FORBID_SINGULAR_OVERWRITES$17960e22};
            }
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private final boolean singleLineMode;
        private boolean atStartOfLine = false;

        /*
         * WARNING - void declaration
         */
        private TextGenerator(Appendable output, boolean singleLineMode) {
            void var2_2;
            void var1_1;
            this.output = var1_1;
            this.singleLineMode = var2_2;
        }

        public final void indent() {
            this.indent.append("  ");
        }

        /*
         * WARNING - void declaration
         */
        public final void outdent() {
            void var1_1;
            int length = this.indent.length();
            if (length == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.setLength((int)(var1_1 - 2));
        }

        /*
         * WARNING - void declaration
         */
        public final void print(CharSequence text) throws IOException {
            void var1_1;
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.singleLineMode ? " " : this.indent);
            }
            this.output.append((CharSequence)var1_1);
        }

        public final void eol() throws IOException {
            if (!this.singleLineMode) {
                this.output.append("\n");
            }
            this.atStartOfLine = true;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ TextGenerator(Appendable x0, boolean x1, byte by) {
            this((Appendable)var1_1, false);
            void var1_1;
        }
    }

    public static final class Printer {
        private static final Printer DEFAULT = new Printer(true, TypeRegistry.getEmptyTypeRegistry());
        private final boolean escapeNonAscii;
        private final TypeRegistry typeRegistry;

        /*
         * WARNING - void declaration
         */
        private Printer(boolean escapeNonAscii, TypeRegistry typeRegistry) {
            void var2_2;
            this.escapeNonAscii = true;
            this.typeRegistry = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void print(MessageOrBuilder message, TextGenerator generator) throws IOException {
            void var2_2;
            void var1_1;
            if (((Descriptors.GenericDescriptor)message.getDescriptorForType()).getFullName().equals("google.protobuf.Any") && this.printAny(message, generator)) {
                return;
            }
            this.printMessage((MessageOrBuilder)var1_1, (TextGenerator)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private boolean printAny(MessageOrBuilder message, TextGenerator generator) throws IOException {
            void var2_2;
            void var3_3;
            Descriptors.Descriptor messageType = message.getDescriptorForType();
            Descriptors.FieldDescriptor typeUrlField = messageType.findFieldByNumber(1);
            Descriptors.FieldDescriptor valueField = messageType.findFieldByNumber(2);
            if (typeUrlField == null || typeUrlField.getType() != Descriptors.FieldDescriptor.Type.STRING || valueField == null || valueField.getType() != Descriptors.FieldDescriptor.Type.BYTES) {
                return false;
            }
            String typeUrl = (String)message.getField(typeUrlField);
            if (typeUrl.isEmpty()) {
                return false;
            }
            Object value = message.getField(valueField);
            try {
                void var1_1;
                Descriptors.Descriptor contentType = this.typeRegistry.getDescriptorForTypeUrl(typeUrl);
                if (contentType == null) {
                    return false;
                }
                DynamicMessage.Builder contentBuilder = DynamicMessage.getDefaultInstance(contentType).newBuilderForType();
                contentBuilder.mergeFrom$3b4858a2((ByteString)var1_1);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                return false;
            }
            generator.print("[");
            generator.print(typeUrl);
            generator.print("] {");
            generator.eol();
            generator.indent();
            this.print((MessageOrBuilder)var3_3, generator);
            generator.outdent();
            generator.print("}");
            var2_2.eol();
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private void printField(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            void var3_3;
            void var1_1;
            void var2_2;
            if (field.isMapField()) {
                ArrayList<MapEntryAdapter> adapters = new ArrayList<MapEntryAdapter>();
                for (Object entry : (List)((Object)value)) {
                    adapters.add(new MapEntryAdapter(entry, field));
                }
                Collections.sort(adapters);
                for (MapEntryAdapter adapter : adapters) {
                    this.printSingleField(field, adapter.getEntry(), generator);
                }
                return;
            }
            if (field.isRepeated()) {
                for (Object element : (List)((Object)value)) {
                    this.printSingleField(field, var2_2, generator);
                }
                return;
            }
            this.printSingleField((Descriptors.FieldDescriptor)var1_1, var2_2, (TextGenerator)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private void printFieldValue(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            String string;
            switch (((Descriptors.FieldDescriptor)((Object)string)).getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value).toString());
                    return;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value).toString());
                    return;
                }
                case BOOL: {
                    generator.print(((Boolean)value).toString());
                    return;
                }
                case FLOAT: {
                    generator.print(((Float)value).toString());
                    return;
                }
                case DOUBLE: {
                    generator.print(((Double)value).toString());
                    return;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value));
                    return;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value));
                    return;
                }
                case STRING: {
                    String string2;
                    generator.print("\"");
                    if (this.escapeNonAscii) {
                        string = (String)value;
                        string2 = TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8$6a838971(string));
                    } else {
                        string2 = TextFormat.escapeDoubleQuotesAndBackslashes((String)value).replace("\n", "\\n");
                    }
                    generator.print(string2);
                    generator.print("\"");
                    return;
                }
                case BYTES: {
                    generator.print("\"");
                    if (value instanceof ByteString) {
                        generator.print(TextFormat.escapeBytes((ByteString)value));
                    } else {
                        generator.print(TextFormat.escapeBytes((byte[])value));
                    }
                    generator.print("\"");
                    return;
                }
                case ENUM: {
                    generator.print(((Descriptors.GenericDescriptor)((Descriptors.EnumValueDescriptor)value)).getName());
                    return;
                }
                case MESSAGE: 
                case GROUP: {
                    void var3_3;
                    void var2_2;
                    this.print((MessageOrBuilder)var2_2, (TextGenerator)var3_3);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final String printToString(MessageOrBuilder message) {
            try {
                Printer printer;
                StringBuilder text;
                StringBuilder stringBuilder = text = new StringBuilder();
                void var3_5 = printer;
                printer = this;
                printer.print((MessageOrBuilder)var3_5, TextFormat.access$200(stringBuilder));
                return text.toString();
            }
            catch (IOException e) {
                void var2_3;
                throw new IllegalStateException((Throwable)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final String printToString(UnknownFieldSet fields) {
            try {
                void var1_1;
                StringBuilder text;
                StringBuilder stringBuilder = text = new StringBuilder();
                Printer.printUnknownFields((UnknownFieldSet)var1_1, TextFormat.access$200(stringBuilder));
                return text.toString();
            }
            catch (IOException e) {
                void var2_3;
                throw new IllegalStateException((Throwable)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static void printUnknownFieldValue(int tag, Object value, TextGenerator generator) throws IOException {
            int n;
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    generator.print(TextFormat.unsignedToString((Long)value));
                    return;
                }
                case 5: {
                    generator.print(String.format(null, "0x%08x", (Integer)value));
                    return;
                }
                case 1: {
                    generator.print(String.format(null, "0x%016x", (Long)value));
                    return;
                }
                case 2: {
                    try {
                        void var0_1;
                        UnknownFieldSet message = UnknownFieldSet.parseFrom((ByteString)value);
                        generator.print("{");
                        generator.eol();
                        generator.indent();
                        Printer.printUnknownFields((UnknownFieldSet)var0_1, generator);
                        generator.outdent();
                        generator.print("}");
                        return;
                    }
                    catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                        generator.print("\"");
                        generator.print(TextFormat.escapeBytes((ByteString)value));
                        generator.print("\"");
                        return;
                    }
                }
                case 3: {
                    void var2_3;
                    void var1_2;
                    Printer.printUnknownFields((UnknownFieldSet)var1_2, (TextGenerator)var2_3);
                    return;
                }
            }
            throw new IllegalArgumentException("Bad tag: " + n);
        }

        /*
         * WARNING - void declaration
         */
        private void printMessage(MessageOrBuilder message, TextGenerator generator) throws IOException {
            void var2_2;
            void var1_1;
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
                this.printField(field.getKey(), field.getValue(), generator);
            }
            Printer.printUnknownFields(var1_1.getUnknownFields(), (TextGenerator)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void printSingleField(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            void var3_3;
            void var1_1;
            void var2_2;
            if (field.isExtension()) {
                generator.print("[");
                if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                    generator.print(((Descriptors.GenericDescriptor)field.getMessageType()).getFullName());
                } else {
                    generator.print(((Descriptors.GenericDescriptor)field).getFullName());
                }
                generator.print("]");
            } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(((Descriptors.GenericDescriptor)field.getMessageType()).getName());
            } else {
                generator.print(((Descriptors.GenericDescriptor)field).getName());
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.print(" {");
                generator.eol();
                generator.indent();
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field, var2_2, generator);
            if (var1_1.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.outdent();
                generator.print("}");
            }
            var3_3.eol();
        }

        /*
         * WARNING - void declaration
         */
        private static void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry entry : unknownFields.asMap().entrySet()) {
                void var3_4;
                int number = (Integer)entry.getKey();
                UnknownFieldSet.Field field = (UnknownFieldSet.Field)entry.getValue();
                Printer.printUnknownField(number, 0, field.getVarintList(), generator);
                Printer.printUnknownField(number, 5, field.getFixed32List(), generator);
                Printer.printUnknownField(number, 1, field.getFixed64List(), generator);
                Printer.printUnknownField((int)var3_4, 2, field.getLengthDelimitedList(), generator);
                for (UnknownFieldSet value : field.getGroupList()) {
                    generator.print(((Integer)entry.getKey()).toString());
                    generator.print(" {");
                    generator.eol();
                    generator.indent();
                    Printer.printUnknownFields(value, generator);
                    generator.outdent();
                    generator.print("}");
                    generator.eol();
                }
            }
        }

        private static void printUnknownField(int number, int wireType, List<?> values, TextGenerator generator) throws IOException {
            for (Object value : values) {
                generator.print(String.valueOf(number));
                generator.print(": ");
                Printer.printUnknownFieldValue(wireType, value, generator);
                generator.eol();
            }
        }

        private static final class MapEntryAdapter
        implements Comparable<MapEntryAdapter> {
            private Object entry;
            private MapEntry mapEntry;
            private final Descriptors.FieldDescriptor.JavaType fieldType;

            /*
             * WARNING - void declaration
             */
            MapEntryAdapter(Object entry, Descriptors.FieldDescriptor fieldDescriptor) {
                void var2_2;
                void var1_1;
                if (entry instanceof MapEntry) {
                    this.mapEntry = (MapEntry)entry;
                } else {
                    this.entry = var1_1;
                }
                var1_1 = var2_2;
                this.fieldType = var1_1.getMessageType().getFields().get(0).getJavaType();
            }

            private Object getKey() {
                if (this.mapEntry != null) {
                    return this.mapEntry.getKey();
                }
                return null;
            }

            final Object getEntry() {
                if (this.mapEntry != null) {
                    return this.mapEntry;
                }
                return this.entry;
            }
        }
    }
}

