/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEROctetString;

public abstract class ASN1BMPString
extends ASN1Primitive {
    private char[] string;

    ASN1BMPString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        int n = byArray.length;
        if (0 != (n & 1)) {
            throw new IllegalArgumentException("malformed BMPString encoding encountered");
        }
        char[] cArray = new char[n /= 2];
        for (int i = 0; i != n; ++i) {
            cArray[i] = (char)(byArray[2 * i] << 8 | byArray[2 * i + 1] & 0xFF);
        }
        this.string = cArray;
    }

    ASN1BMPString(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = cArray;
    }

    public String toString() {
        ASN1BMPString aSN1BMPString = this;
        return new String(aSN1BMPString.string);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1BMPString)) {
            return false;
        }
        object = (ASN1BMPString)object;
        char[] cArray = ((ASN1BMPString)object).string;
        object = this.string;
        return Arrays.equals(this.string, cArray);
    }

    public final int hashCode() {
        char[] cArray = this.string;
        if (this.string == null) {
            return 0;
        }
        int n = cArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= cArray[n];
        }
        return n2;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.string.length << 1);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        char c;
        int n;
        int n2;
        int n3 = this.string.length;
        aSN1OutputStream.writeIdentifier(bl, 30);
        aSN1OutputStream.writeDL(n3 << 1);
        byte[] byArray = new byte[8];
        int n4 = n3 & 0xFFFFFFFC;
        for (n2 = 0; n2 < n4; n2 += 4) {
            n = this.string[n2];
            c = this.string[n2 + 1];
            char c2 = this.string[n2 + 2];
            char c3 = this.string[n2 + 3];
            byArray[0] = (byte)(n >> 8);
            byArray[1] = (byte)n;
            byArray[2] = (byte)(c >> 8);
            byArray[3] = (byte)c;
            byArray[4] = (byte)(c2 >> 8);
            byArray[5] = (byte)c2;
            byArray[6] = (byte)(c3 >> 8);
            byArray[7] = (byte)c3;
            aSN1OutputStream.write(byArray, 0, 8);
        }
        if (n2 < n3) {
            n = 0;
            do {
                c = this.string[n2];
                byArray[n++] = (byte)(c >> 8);
                byArray[n++] = (byte)c;
            } while (++n2 < n3);
            aSN1OutputStream.write(byArray, 0, n);
        }
    }

    static DERBMPString createPrimitive$7cfc87ea(byte[] byArray) {
        return new DERBMPString(byArray);
    }

    static DERBMPString createPrimitive$4c046f57(char[] cArray) {
        return new DERBMPString(cArray);
    }

    static {
        new ASN1UniversalType(ASN1BMPString.class, 30){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1BMPString.createPrimitive$7cfc87ea(dEROctetString.string);
            }
        };
    }
}

