/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitStringParser;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.util.Arrays;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1BitStringParser {
    static final 1 TYPE$2098b15f = new ASN1UniversalType(ASN1BitString.class, 3){

        final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1BitString.createPrimitive(dEROctetString.string);
        }

        final ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.toASN1BitString();
        }
    };
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final byte[] contents;

    public static ASN1BitString getInstance$7c1c9dd(ASN1Encodable aSN1Encodable) {
        ASN1Primitive aSN1Primitive;
        if (aSN1Encodable == null || aSN1Encodable instanceof ASN1BitString) {
            return (ASN1BitString)aSN1Encodable;
        }
        if (aSN1Encodable instanceof ASN1Encodable && (aSN1Primitive = aSN1Encodable.toASN1Primitive()) instanceof ASN1BitString) {
            return (ASN1BitString)aSN1Primitive;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + aSN1Encodable.getClass().getName());
    }

    public static ASN1BitString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1BitString)TYPE$2098b15f.getContextInstance(aSN1TaggedObject, false);
    }

    ASN1BitString(byte[] byArray, int n) {
        byte[] byArray2;
        if (byArray == null) {
            throw new NullPointerException("'data' cannot be null");
        }
        if (byArray.length == 0 && n != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        n = (byte)n;
        if (byArray == null) {
            byte[] byArray3 = new byte[1];
            byArray2 = byArray3;
            byArray3[0] = n;
        } else {
            int n2 = byArray.length;
            byte[] byArray4 = new byte[n2 + 1];
            System.arraycopy(byArray, 0, byArray4, 1, n2);
            byArray4[0] = n;
            byArray2 = byArray4;
        }
        this.contents = byArray2;
    }

    ASN1BitString(byte[] byArray, boolean n) {
        if (n != 0) {
            if (byArray == null) {
                throw new NullPointerException("'contents' cannot be null");
            }
            if (byArray.length <= 0) {
                throw new IllegalArgumentException("'contents' cannot be empty");
            }
            n = byArray[0] & 0xFF;
            if (n > 0) {
                if (byArray.length < 2) {
                    throw new IllegalArgumentException("zero length data with non-zero pad bits");
                }
                if (n > 7) {
                    throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
                }
            }
        }
        this.contents = byArray;
    }

    public final InputStream getBitStream() throws IOException {
        return new ByteArrayInputStream(this.contents, 1, this.contents.length - 1);
    }

    private String getString() {
        byte[] byArray;
        try {
            byArray = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        StringBuffer stringBuffer = new StringBuffer(1 + (byArray.length << 1));
        stringBuffer.append('#');
        for (int i = 0; i != byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(table[by >>> 4 & 0xF]);
            stringBuffer.append(table[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    public final byte[] getOctets() {
        if (this.contents[0] != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return Arrays.copyOfRange(this.contents, 1, this.contents.length);
    }

    public final byte[] getBytes() {
        if (this.contents.length == 1) {
            return ASN1OctetString.EMPTY_OCTETS;
        }
        int n = this.contents[0] & 0xFF;
        byte[] byArray = Arrays.copyOfRange(this.contents, 1, this.contents.length);
        byte[] byArray2 = byArray;
        int n2 = byArray2.length - 1;
        byArray[n2] = (byte)(byArray[n2] & (byte)(255 << n));
        return byArray2;
    }

    public final int getPadBits() {
        return this.contents[0] & 0xFF;
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        int n;
        if (this.contents.length < 2) {
            return 1;
        }
        int n2 = this.contents[0] & 0xFF;
        int n3 = this.contents.length - 1;
        n2 = (byte)(this.contents[n3] & 255 << n2);
        int n4 = n3;
        n3 = 0;
        byte[] byArray = this.contents;
        if (this.contents == null) {
            n = 0;
        } else {
            int n5 = n4 + 1;
            while (--n4 >= 0) {
                n5 *= 257;
                n5 ^= byArray[n4 + 0];
            }
            n = n5;
        }
        int n6 = n;
        n6 = n * 257;
        return n6 ^= n2;
    }

    final boolean asn1Equals(ASN1Primitive object) {
        int n;
        if (!(object instanceof ASN1BitString)) {
            return false;
        }
        object = (ASN1BitString)object;
        object = ((ASN1BitString)object).contents;
        byte[] byArray = this.contents;
        int n2 = byArray.length;
        if (((Object)object).length != n2) {
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        --n2;
        for (n = 0; n < n2; ++n) {
            if (byArray[n] == object[n]) continue;
            return false;
        }
        n = byArray[0] & 0xFF;
        byte by = (byte)(byArray[n2] & 255 << n);
        byte by2 = (byte)(object[n2] & 255 << n);
        return by == by2;
    }

    public final ASN1Primitive getLoadedObject() {
        return ((ASN1Object)this).toASN1Primitive();
    }

    ASN1Primitive toDERObject() {
        return new DERBitString(this.contents, false);
    }

    ASN1Primitive toDLObject() {
        return new DLBitString(this.contents, false);
    }

    static ASN1BitString createPrimitive(byte[] byArray) {
        int n = byArray.length;
        if (n <= 0) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n2 = byArray[0] & 0xFF;
        if (n2 > 0) {
            if (n2 > 7 || n < 2) {
                throw new IllegalArgumentException("invalid pad bits detected");
            }
            if ((n = byArray[n - 1]) != (byte)(n & 255 << n2)) {
                return new DLBitString(byArray, false);
            }
        }
        return new DERBitString(byArray, false);
    }
}

