/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import org.bouncycastle.asn1.ASN1Encodable;

public final class ASN1EncodableVector {
    static final ASN1Encodable[] EMPTY_ELEMENTS = new ASN1Encodable[0];
    private ASN1Encodable[] elements;
    private int elementCount;
    private boolean copyOnWrite;

    public ASN1EncodableVector() {
        this(10);
    }

    public ASN1EncodableVector(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("'initialCapacity' must not be negative");
        }
        this.elements = n == 0 ? EMPTY_ELEMENTS : new ASN1Encodable[n];
        this.elementCount = 0;
        this.copyOnWrite = false;
    }

    public final void add(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable == null) {
            throw new NullPointerException("'element' cannot be null");
        }
        int n = this.elementCount + 1;
        int n2 = this.elements.length;
        if (n > n2 | this.copyOnWrite) {
            int n3 = n;
            ASN1EncodableVector aSN1EncodableVector = this;
            int n4 = aSN1EncodableVector.elements.length;
            int n5 = n3;
            n3 = Math.max(n4, n5 + (n5 >> 1));
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[n3];
            System.arraycopy(aSN1EncodableVector.elements, 0, aSN1EncodableArray, 0, aSN1EncodableVector.elementCount);
            aSN1EncodableVector.elements = aSN1EncodableArray;
            aSN1EncodableVector.copyOnWrite = false;
        }
        this.elements[this.elementCount] = aSN1Encodable;
        this.elementCount = n;
    }

    public final ASN1Encodable get(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        return this.elements[n];
    }

    public final int size() {
        return this.elementCount;
    }

    final ASN1Encodable[] takeElements() {
        if (this.elementCount == 0) {
            return EMPTY_ELEMENTS;
        }
        if (this.elements.length == this.elementCount) {
            this.copyOnWrite = true;
            return this.elements;
        }
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[this.elementCount];
        System.arraycopy(this.elements, 0, aSN1EncodableArray, 0, this.elementCount);
        return aSN1EncodableArray;
    }

    static ASN1Encodable[] cloneElements(ASN1Encodable[] aSN1EncodableArray) {
        if (aSN1EncodableArray.length <= 0) {
            return EMPTY_ELEMENTS;
        }
        return (ASN1Encodable[])aSN1EncodableArray.clone();
    }
}

