/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.ASN1Util;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DLExternal;
import org.bouncycastle.util.Objects;

public abstract class ASN1External
extends ASN1Primitive {
    ASN1ObjectIdentifier directReference;
    ASN1Integer indirectReference;
    ASN1Primitive dataValueDescriptor;
    int encoding;
    ASN1Primitive externalContent;

    ASN1External(ASN1Sequence aSN1Primitive) {
        ASN1Primitive aSN1Primitive2;
        int n = 0;
        ASN1Primitive aSN1Primitive3 = ASN1External.getObjFromSequence((ASN1Sequence)aSN1Primitive, 0);
        if (aSN1Primitive3 instanceof ASN1ObjectIdentifier) {
            this.directReference = (ASN1ObjectIdentifier)aSN1Primitive3;
            ++n;
            aSN1Primitive3 = ASN1External.getObjFromSequence((ASN1Sequence)aSN1Primitive, 1);
        }
        if (aSN1Primitive3 instanceof ASN1Integer) {
            this.indirectReference = (ASN1Integer)aSN1Primitive3;
            aSN1Primitive3 = ASN1External.getObjFromSequence((ASN1Sequence)aSN1Primitive, ++n);
        }
        if (!(aSN1Primitive3 instanceof ASN1TaggedObject)) {
            this.dataValueDescriptor = aSN1Primitive3;
            aSN1Primitive3 = ASN1External.getObjFromSequence((ASN1Sequence)aSN1Primitive, ++n);
        }
        if (((ASN1Sequence)aSN1Primitive).size() != n + 1) {
            throw new IllegalArgumentException("input sequence too large");
        }
        if (!(aSN1Primitive3 instanceof ASN1TaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in sequence. Structure doesn't seem to be of type External");
        }
        aSN1Primitive3 = aSN1Primitive = (ASN1TaggedObject)aSN1Primitive3;
        this.encoding = ASN1External.checkEncoding(((ASN1TaggedObject)aSN1Primitive3).tagNo);
        aSN1Primitive3 = aSN1Primitive;
        n = ((ASN1TaggedObject)aSN1Primitive).tagClass;
        aSN1Primitive3 = aSN1Primitive;
        int n2 = ((ASN1TaggedObject)aSN1Primitive3).tagNo;
        if (128 != n) {
            throw new IllegalArgumentException("invalid tag: " + ASN1Util.getTagText(n, n2));
        }
        switch (n2) {
            case 0: {
                if (!((ASN1TaggedObject)aSN1Primitive).isExplicit()) {
                    throw new IllegalStateException("object implicit - explicit expected.");
                }
                aSN1Primitive2 = (((ASN1TaggedObject)aSN1Primitive).obj instanceof ASN1Object ? (ASN1Object)((ASN1TaggedObject)aSN1Primitive).obj : ((ASN1TaggedObject)aSN1Primitive).obj.toASN1Primitive()).toASN1Primitive();
                break;
            }
            case 1: {
                aSN1Primitive2 = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                break;
            }
            case 2: {
                aSN1Primitive2 = ASN1BitString.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tag: " + ASN1Util.getTagText(n, n2));
            }
        }
        this.externalContent = aSN1Primitive2;
    }

    ASN1External(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Integer aSN1Primitive, ASN1Primitive aSN1Primitive2, int n, ASN1Primitive aSN1Primitive3) {
        ASN1Primitive aSN1Primitive4;
        this.directReference = aSN1ObjectIdentifier;
        this.indirectReference = aSN1Primitive;
        this.dataValueDescriptor = aSN1Primitive2;
        this.encoding = ASN1External.checkEncoding(n);
        aSN1Primitive = aSN1Primitive3;
        int n2 = n;
        switch (n2) {
            case 1: {
                aSN1Primitive4 = ASN1OctetString.TYPE$2098b15f.checkedCast(aSN1Primitive);
                break;
            }
            case 2: {
                aSN1Primitive4 = ASN1BitString.TYPE$2098b15f.checkedCast(aSN1Primitive);
                break;
            }
            default: {
                aSN1Primitive4 = aSN1Primitive;
            }
        }
        this.externalContent = aSN1Primitive4;
    }

    abstract ASN1Sequence buildSequence();

    final int encodedLength(boolean bl) throws IOException {
        return this.buildSequence().encodedLength(bl);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeIdentifier(bl, 40);
        this.buildSequence().encode(aSN1OutputStream, false);
    }

    ASN1Primitive toDERObject() {
        return new DERExternal(this.directReference, this.indirectReference, this.dataValueDescriptor, this.encoding, this.externalContent);
    }

    ASN1Primitive toDLObject() {
        return new DLExternal(this.directReference, this.indirectReference, this.dataValueDescriptor, this.encoding, this.externalContent);
    }

    public int hashCode() {
        return Objects.hashCode$5d527804(this.directReference) ^ Objects.hashCode$5d527804(this.indirectReference) ^ Objects.hashCode$5d527804(this.dataValueDescriptor) ^ this.encoding ^ this.externalContent.hashCode();
    }

    final boolean encodeConstructed() {
        return true;
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (this == aSN1Primitive) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1External)) {
            return false;
        }
        aSN1Primitive = (ASN1External)aSN1Primitive;
        return Objects.areEqual$2838e5b1(this.directReference, ((ASN1External)aSN1Primitive).directReference) && Objects.areEqual$2838e5b1(this.indirectReference, ((ASN1External)aSN1Primitive).indirectReference) && Objects.areEqual$2838e5b1(this.dataValueDescriptor, ((ASN1External)aSN1Primitive).dataValueDescriptor) && this.encoding == ((ASN1External)aSN1Primitive).encoding && this.externalContent.equals(((ASN1External)aSN1Primitive).externalContent);
    }

    private static int checkEncoding(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + n);
        }
        return n;
    }

    private static ASN1Primitive getObjFromSequence(ASN1Sequence aSN1Sequence, int n) {
        if (aSN1Sequence.size() <= n) {
            throw new IllegalArgumentException("too few objects in input sequence");
        }
        return aSN1Sequence.getObjectAt(n).toASN1Primitive();
    }

    static {
        new ASN1UniversalType(ASN1External.class, 8){

            final ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
                return aSN1Sequence.toASN1External();
            }
        };
    }
}

