/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    final byte[] contents;

    ASN1GeneralizedTime(byte[] byArray) {
        if (byArray.length < 4) {
            throw new IllegalArgumentException("GeneralizedTime string too short");
        }
        this.contents = byArray;
        if (!(this.isDigit(0) && this.isDigit(1) && this.isDigit(2) && this.isDigit(3))) {
            throw new IllegalArgumentException("illegal characters in GeneralizedTime string");
        }
    }

    protected final boolean hasSeconds() {
        return this.isDigit(12) && this.isDigit(13);
    }

    protected final boolean hasMinutes() {
        return this.isDigit(10) && this.isDigit(11);
    }

    private boolean isDigit(int n) {
        return this.contents.length > n && this.contents[n] >= 48 && this.contents[n] <= 57;
    }

    final boolean encodeConstructed() {
        return false;
    }

    int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 24, this.contents);
    }

    ASN1Primitive toDERObject() {
        return new DERGeneralizedTime(this.contents);
    }

    ASN1Primitive toDLObject() {
        return new DERGeneralizedTime(this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1GeneralizedTime)) {
            return false;
        }
        byte[] byArray = ((ASN1GeneralizedTime)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1GeneralizedTime createPrimitive(byte[] byArray) {
        return new ASN1GeneralizedTime(byArray);
    }

    static {
        new ASN1UniversalType(ASN1GeneralizedTime.class, 24){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1GeneralizedTime.createPrimitive(dEROctetString.string);
            }
        };
    }
}

