/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;

public abstract class ASN1GraphicString
extends ASN1Primitive {
    static final 1 TYPE$2098b15f = new ASN1UniversalType(ASN1GraphicString.class, 25){

        final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1GraphicString.createPrimitive$6b4a772d(dEROctetString.string);
        }
    };
    private byte[] contents;

    ASN1GraphicString(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("'contents' cannot be null");
        }
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 25, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1GraphicString)) {
            return false;
        }
        object = (ASN1GraphicString)object;
        byte[] byArray = ((ASN1GraphicString)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static DERGraphicString createPrimitive$6b4a772d(byte[] byArray) {
        return new DERGraphicString(byArray, false);
    }
}

