/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1IA5String
extends ASN1Primitive {
    private byte[] contents;

    ASN1IA5String(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public String toString() {
        ASN1IA5String aSN1IA5String = this;
        return Strings.fromByteArray(aSN1IA5String.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 22, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1IA5String)) {
            return false;
        }
        object = (ASN1IA5String)object;
        byte[] byArray = ((ASN1IA5String)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static DERIA5String createPrimitive$4910a05e(byte[] byArray) {
        return new DERIA5String(byArray, false);
    }

    static {
        new ASN1UniversalType(ASN1IA5String.class, 22){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1IA5String.createPrimitive$4910a05e(dEROctetString.string);
            }
        };
    }
}

