/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BMPString;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Exception;
import org.bouncycastle.asn1.ASN1GeneralString;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1GraphicString;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1NumericString;
import org.bouncycastle.asn1.ASN1ObjectDescriptor;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1RelativeOID;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1T61String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.ASN1UniversalString;
import org.bouncycastle.asn1.ASN1VideotexString;
import org.bouncycastle.asn1.ASN1VisibleString;
import org.bouncycastle.asn1.BERBitString;
import org.bouncycastle.asn1.BERBitStringParser;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DLFactory;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;
import org.bouncycastle.asn1.LazyEncodedSequence;
import org.bouncycastle.asn1.LimitedInputStream;
import org.bouncycastle.util.io.Streams;

public final class ASN1InputStream
extends FilterInputStream {
    private final int limit;
    private final boolean lazyEvaluate;
    private final byte[][] tmpBuffers;

    public ASN1InputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(byte[] byArray, boolean bl) {
        this(new ByteArrayInputStream(byArray), byArray.length, true);
    }

    private ASN1InputStream(InputStream inputStream, int n) {
        this(inputStream, n, false);
    }

    private ASN1InputStream(InputStream inputStream, int n, boolean bl) {
        this(inputStream, n, bl, new byte[11][]);
    }

    private ASN1InputStream(InputStream inputStream, int n, boolean bl, byte[][] byArray) {
        super(inputStream);
        this.limit = n;
        this.lazyEvaluate = bl;
        this.tmpBuffers = byArray;
    }

    public final ASN1Primitive readObject() throws IOException {
        int n = this.read();
        if (n <= 0) {
            if (n == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n2 = ASN1InputStream.readTagNumber((InputStream)this, n);
        ASN1BitString[] aSN1BitStringArray = this;
        int n3 = ASN1InputStream.readLength((InputStream)this, aSN1BitStringArray.limit, false);
        if (n3 >= 0) {
            try {
                Object object;
                int n4;
                DefiniteLengthInputStream definiteLengthInputStream;
                int n5 = n3;
                ASN1Primitive[] aSN1PrimitiveArray = this;
                DefiniteLengthInputStream definiteLengthInputStream2 = new DefiniteLengthInputStream((InputStream)aSN1PrimitiveArray, n5, aSN1PrimitiveArray.limit);
                if (0 == (n & 0xE0)) {
                    return ASN1InputStream.createPrimitiveDERObject(n2, definiteLengthInputStream2, aSN1PrimitiveArray.tmpBuffers);
                }
                int n6 = n & 0xC0;
                if (n6 != 0) {
                    n = (n & 0x20) != 0 ? 1 : 0;
                    definiteLengthInputStream = definiteLengthInputStream2;
                    int n7 = n;
                    n4 = n2;
                    n2 = n6;
                    object = aSN1PrimitiveArray;
                    if (n7 != 0) {
                        object = object.readVector(definiteLengthInputStream);
                        return ASN1TaggedObject.createConstructedDL(n2, n4, (ASN1EncodableVector)object);
                    }
                } else {
                    switch (n2) {
                        case 3: {
                            ASN1EncodableVector aSN1EncodableVector = aSN1PrimitiveArray.readVector(definiteLengthInputStream2);
                            aSN1PrimitiveArray = new ASN1BitString[aSN1EncodableVector.size()];
                            for (int i = 0; i != aSN1PrimitiveArray.length; ++i) {
                                ASN1Encodable aSN1Encodable = aSN1EncodableVector.get(i);
                                if (!(aSN1Encodable instanceof ASN1BitString)) {
                                    throw new ASN1Exception("unknown object encountered in constructed BIT STRING: " + aSN1Encodable.getClass());
                                }
                                aSN1PrimitiveArray[i] = (ASN1BitString)aSN1Encodable;
                            }
                            return new BERBitString((ASN1BitString[])aSN1PrimitiveArray);
                        }
                        case 4: {
                            ASN1EncodableVector aSN1EncodableVector = aSN1PrimitiveArray.readVector(definiteLengthInputStream2);
                            aSN1PrimitiveArray = new ASN1OctetString[aSN1EncodableVector.size()];
                            for (int i = 0; i != aSN1PrimitiveArray.length; ++i) {
                                ASN1Encodable aSN1Encodable = aSN1EncodableVector.get(i);
                                if (!(aSN1Encodable instanceof ASN1OctetString)) {
                                    throw new ASN1Exception("unknown object encountered in constructed OCTET STRING: " + aSN1Encodable.getClass());
                                }
                                aSN1PrimitiveArray[i] = (ASN1OctetString)aSN1Encodable;
                            }
                            return new BEROctetString((ASN1OctetString[])aSN1PrimitiveArray);
                        }
                        case 16: {
                            if (definiteLengthInputStream2.getRemaining() <= 0) {
                                return DLFactory.EMPTY_SEQUENCE;
                            }
                            if (aSN1PrimitiveArray.lazyEvaluate) {
                                return new LazyEncodedSequence(definiteLengthInputStream2.toByteArray());
                            }
                            return DLFactory.createSequence(aSN1PrimitiveArray.readVector(definiteLengthInputStream2));
                        }
                        case 17: {
                            return DLFactory.createSet(aSN1PrimitiveArray.readVector(definiteLengthInputStream2));
                        }
                        case 8: {
                            return DLFactory.createSequence(aSN1PrimitiveArray.readVector(definiteLengthInputStream2)).toASN1External();
                        }
                    }
                    throw new IOException("unknown tag " + n2 + " encountered");
                }
                object = definiteLengthInputStream.toByteArray();
                return ASN1TaggedObject.createPrimitive(n2, n4, (byte[])object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
            }
        }
        if (0 == (n & 0x20)) {
            throw new IOException("indefinite-length primitive encoding encountered");
        }
        Object object = new IndefiniteLengthInputStream((InputStream)this, this.limit);
        object = new ASN1StreamParser((LimitedInputStream)object, this.limit, this.tmpBuffers);
        if ((n &= 0xC0) != 0) {
            return ((ASN1StreamParser)object).loadTaggedIL(n, n2);
        }
        switch (n2) {
            case 3: {
                return BERBitStringParser.parse((ASN1StreamParser)object);
            }
            case 4: {
                return BEROctetStringParser.parse((ASN1StreamParser)object);
            }
            case 8: {
                return DERExternalParser.parse((ASN1StreamParser)object);
            }
            case 16: {
                return BERSequenceParser.parse((ASN1StreamParser)object);
            }
            case 17: {
                return BERSetParser.parse((ASN1StreamParser)object);
            }
        }
        throw new IOException("unknown BER object encountered");
    }

    final ASN1EncodableVector readVector() throws IOException {
        ASN1Primitive aSN1Primitive = this.readObject();
        if (aSN1Primitive == null) {
            return new ASN1EncodableVector(0);
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        do {
            aSN1EncodableVector.add(aSN1Primitive);
        } while ((aSN1Primitive = this.readObject()) != null);
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector readVector(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        int n = definiteLengthInputStream.getRemaining();
        if (n <= 0) {
            return new ASN1EncodableVector(0);
        }
        return new ASN1InputStream(definiteLengthInputStream, n, this.lazyEvaluate, this.tmpBuffers).readVector();
    }

    static int readTagNumber(InputStream inputStream, int n) throws IOException {
        if ((n &= 0x1F) == 31) {
            n = 0;
            int n2 = inputStream.read();
            if (n2 < 31) {
                if (n2 < 0) {
                    throw new EOFException("EOF found inside tag value.");
                }
                throw new IOException("corrupted stream - high tag number < 31 found");
            }
            if ((n2 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while ((n2 & 0x80) != 0) {
                if (n >>> 24 != 0) {
                    throw new IOException("Tag number more than 31 bits");
                }
                n |= n2 & 0x7F;
                n <<= 7;
                n2 = inputStream.read();
                if (n2 >= 0) continue;
                throw new EOFException("EOF found inside tag value.");
            }
            n |= n2 & 0x7F;
        }
        return n;
    }

    static int readLength(InputStream inputStream, int n, boolean bl) throws IOException {
        int n2 = inputStream.read();
        if (0 == n2 >>> 7) {
            return n2;
        }
        if (128 == n2) {
            return -1;
        }
        if (n2 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (255 == n2) {
            throw new IOException("invalid long form definite-length 0xFF");
        }
        int n3 = n2 & 0x7F;
        int n4 = 0;
        n2 = 0;
        do {
            int n5;
            if ((n5 = inputStream.read()) < 0) {
                throw new EOFException("EOF found reading length");
            }
            if (n2 >>> 23 != 0) {
                throw new IOException("long form definite-length more than 31 bits");
            }
            n2 = (n2 << 8) + n5;
        } while (++n4 < n3);
        if (n2 >= n && !bl) {
            throw new IOException("corrupted stream - out of bounds length found: " + n2 + " >= " + n);
        }
        return n2;
    }

    private static byte[] getBuffer(DefiniteLengthInputStream definiteLengthInputStream, byte[][] byArray) throws IOException {
        int n = definiteLengthInputStream.getRemaining();
        if (n >= byArray.length) {
            return definiteLengthInputStream.toByteArray();
        }
        byte[] byArray2 = byArray[n];
        if (byArray2 == null) {
            int n2 = n;
            byte[] byArray3 = new byte[n2];
            byArray[n2] = byArray3;
            byArray2 = byArray3;
        }
        definiteLengthInputStream.readAllIntoByteArray(byArray2);
        return byArray2;
    }

    private static char[] getBMPCharBuffer(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        int n = definiteLengthInputStream.getRemaining();
        if (0 != (n & 1)) {
            throw new IOException("malformed BMPString encoding encountered");
        }
        char[] cArray = new char[n / 2];
        int n2 = 0;
        byte[] byArray = new byte[8];
        while (n >= 8) {
            if (Streams.readFully(definiteLengthInputStream, byArray, 0, 8) != 8) {
                throw new EOFException("EOF encountered in middle of BMPString");
            }
            cArray[n2] = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
            cArray[n2 + 1] = (char)(byArray[2] << 8 | byArray[3] & 0xFF);
            cArray[n2 + 2] = (char)(byArray[4] << 8 | byArray[5] & 0xFF);
            cArray[n2 + 3] = (char)(byArray[6] << 8 | byArray[7] & 0xFF);
            n2 += 4;
            n -= 8;
        }
        if (n > 0) {
            if (Streams.readFully(definiteLengthInputStream, byArray, 0, n) != n) {
                throw new EOFException("EOF encountered in middle of BMPString");
            }
            int n3 = 0;
            do {
                int n4 = byArray[n3++] << 8;
                int n5 = byArray[n3++] & 0xFF;
                cArray[n2++] = (char)(n4 | n5);
            } while (n3 < n);
        }
        if (0 != definiteLengthInputStream.getRemaining() || cArray.length != n2) {
            throw new IllegalStateException();
        }
        return cArray;
    }

    static ASN1Primitive createPrimitiveDERObject(int n, DefiniteLengthInputStream definiteLengthInputStream, byte[][] byArray) throws IOException {
        switch (n) {
            case 3: {
                return ASN1BitString.createPrimitive(definiteLengthInputStream.toByteArray());
            }
            case 30: {
                return ASN1BMPString.createPrimitive$4c046f57(ASN1InputStream.getBMPCharBuffer(definiteLengthInputStream));
            }
            case 1: {
                return ASN1Boolean.createPrimitive(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray));
            }
            case 10: {
                return ASN1Enumerated.createPrimitive(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray), true);
            }
            case 27: {
                return ASN1GeneralString.createPrimitive$5e572d3(definiteLengthInputStream.toByteArray());
            }
            case 24: {
                return ASN1GeneralizedTime.createPrimitive(definiteLengthInputStream.toByteArray());
            }
            case 25: {
                return ASN1GraphicString.createPrimitive$6b4a772d(definiteLengthInputStream.toByteArray());
            }
            case 22: {
                return ASN1IA5String.createPrimitive$4910a05e(definiteLengthInputStream.toByteArray());
            }
            case 2: {
                return ASN1Integer.createPrimitive(definiteLengthInputStream.toByteArray());
            }
            case 5: {
                return ASN1Null.createPrimitive$3a84821d(definiteLengthInputStream.toByteArray());
            }
            case 18: {
                return ASN1NumericString.createPrimitive$ead9d0e(definiteLengthInputStream.toByteArray());
            }
            case 7: {
                return ASN1ObjectDescriptor.createPrimitive(definiteLengthInputStream.toByteArray());
            }
            case 6: {
                return ASN1ObjectIdentifier.createPrimitive(ASN1InputStream.getBuffer(definiteLengthInputStream, byArray), true);
            }
            case 4: {
                return ASN1OctetString.createPrimitive$71f4784c(definiteLengthInputStream.toByteArray());
            }
            case 19: {
                return ASN1PrintableString.createPrimitive$2dffd114(definiteLengthInputStream.toByteArray());
            }
            case 13: {
                return ASN1RelativeOID.createPrimitive(definiteLengthInputStream.toByteArray(), false);
            }
            case 20: {
                return ASN1T61String.createPrimitive$363cfbd4(definiteLengthInputStream.toByteArray());
            }
            case 28: {
                return ASN1UniversalString.createPrimitive$3c9d2830(definiteLengthInputStream.toByteArray());
            }
            case 23: {
                return ASN1UTCTime.createPrimitive(definiteLengthInputStream.toByteArray());
            }
            case 12: {
                return ASN1UTF8String.createPrimitive$b3390a8(definiteLengthInputStream.toByteArray());
            }
            case 21: {
                return ASN1VideotexString.createPrimitive$44587d93(definiteLengthInputStream.toByteArray());
            }
            case 26: {
                return ASN1VisibleString.createPrimitive$46d323f7(definiteLengthInputStream.toByteArray());
            }
        }
        throw new IOException("unknown tag " + n + " encountered");
    }
}

