/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

public class ASN1Integer
extends ASN1Primitive {
    private static 1 TYPE$2098b15f = new ASN1UniversalType(ASN1Integer.class, 2){

        final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1Integer.createPrimitive(dEROctetString.string);
        }
    };
    private final byte[] bytes;
    private final int start;

    public static ASN1Integer getInstance(Object object) {
        if (object == null || object instanceof ASN1Integer) {
            return (ASN1Integer)object;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1Integer)TYPE$2098b15f.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1Integer)TYPE$2098b15f.getContextInstance(aSN1TaggedObject, false);
    }

    public ASN1Integer(long l) {
        this.bytes = BigInteger.valueOf(l).toByteArray();
        this.start = 0;
    }

    public ASN1Integer(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
        this.start = 0;
    }

    private ASN1Integer(byte[] byArray, boolean bl) {
        if (ASN1Integer.isMalformed(byArray)) {
            throw new IllegalArgumentException("malformed integer");
        }
        this.bytes = byArray;
        this.start = ASN1Integer.signBytesToSkip(byArray);
    }

    public final boolean hasValue(int n) {
        return this.bytes.length - this.start <= 4 && ASN1Integer.intValue(this.bytes, this.start, -1) == n;
    }

    public final int intValueExact() {
        int n = this.bytes.length - this.start;
        if (n > 4) {
            throw new ArithmeticException("ASN.1 Integer out of int range");
        }
        return ASN1Integer.intValue(this.bytes, this.start, -1);
    }

    public final long longValueExact() {
        int n = this.bytes.length - this.start;
        if (n > 8) {
            throw new ArithmeticException("ASN.1 Integer out of long range");
        }
        n = -1;
        int n2 = this.start;
        byte[] byArray = this.bytes;
        int n3 = this.bytes.length;
        n2 = Math.max(n2, n3 - 8);
        long l = byArray[n2];
        while (++n2 < n3) {
            l = l << 8 | (long)(byArray[n2] & 0xFF);
        }
        return l;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.bytes.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 2, this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1Integer)) {
            return false;
        }
        object = (ASN1Integer)object;
        byte[] byArray = ((ASN1Integer)object).bytes;
        object = this.bytes;
        return java.util.Arrays.equals(this.bytes, byArray);
    }

    public String toString() {
        ASN1Integer aSN1Integer = this;
        return new BigInteger(aSN1Integer.bytes).toString();
    }

    static ASN1Integer createPrimitive(byte[] byArray) {
        return new ASN1Integer(byArray, false);
    }

    private static int intValue(byte[] byArray, int n, int n2) {
        n2 = byArray.length;
        n = Math.max(n, n2 - 4);
        int n3 = byArray[n];
        while (++n < n2) {
            n3 = n3 << 8 | byArray[n] & 0xFF;
        }
        return n3;
    }

    static boolean isMalformed(byte[] byArray) {
        switch (byArray.length) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return byArray[0] == byArray[1] >> 7 && !Properties.isOverrideSet("org.bouncycastle.asn1.allow_unsafe_integer");
    }

    static int signBytesToSkip(byte[] byArray) {
        int n;
        int n2 = byArray.length - 1;
        for (n = 0; n < n2 && byArray[n] == byArray[n + 1] >> 7; ++n) {
        }
        return n;
    }
}

