/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1GraphicString;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;

public final class ASN1ObjectDescriptor
extends ASN1Primitive {
    private final ASN1GraphicString baseGraphicString;

    public ASN1ObjectDescriptor(ASN1GraphicString aSN1GraphicString) {
        if (aSN1GraphicString == null) {
            throw new NullPointerException("'baseGraphicString' cannot be null");
        }
        this.baseGraphicString = aSN1GraphicString;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return this.baseGraphicString.encodedLength(bl);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeIdentifier(bl, 7);
        this.baseGraphicString.encode(aSN1OutputStream, false);
    }

    final ASN1Primitive toDERObject() {
        ASN1GraphicString aSN1GraphicString = (ASN1GraphicString)this.baseGraphicString.toDERObject();
        if (aSN1GraphicString == this.baseGraphicString) {
            return this;
        }
        return new ASN1ObjectDescriptor(aSN1GraphicString);
    }

    final ASN1Primitive toDLObject() {
        ASN1GraphicString aSN1GraphicString = (ASN1GraphicString)this.baseGraphicString.toDLObject();
        if (aSN1GraphicString == this.baseGraphicString) {
            return this;
        }
        return new ASN1ObjectDescriptor(aSN1GraphicString);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1ObjectDescriptor)) {
            return false;
        }
        aSN1Primitive = (ASN1ObjectDescriptor)aSN1Primitive;
        return this.baseGraphicString.asn1Equals(((ASN1ObjectDescriptor)aSN1Primitive).baseGraphicString);
    }

    public final int hashCode() {
        return ~((ASN1Object)this.baseGraphicString).hashCode();
    }

    static ASN1ObjectDescriptor createPrimitive(byte[] byArray) {
        return new ASN1ObjectDescriptor(ASN1GraphicString.createPrimitive$6b4a772d(byArray));
    }

    static {
        new ASN1UniversalType(ASN1ObjectDescriptor.class, 7){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return new ASN1ObjectDescriptor((ASN1GraphicString)((ASN1UniversalType)ASN1GraphicString.TYPE$2098b15f).fromImplicitPrimitive(dEROctetString));
            }

            final ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
                return new ASN1ObjectDescriptor((ASN1GraphicString)ASN1GraphicString.TYPE$2098b15f.fromImplicitConstructed(aSN1Sequence));
            }
        };
    }
}

