/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1RelativeOID;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.OIDTokenizer;
import org.bouncycastle.util.Arrays;

public class ASN1ObjectIdentifier
extends ASN1Primitive {
    private static 1 TYPE$2098b15f = new ASN1UniversalType(ASN1ObjectIdentifier.class, 6){

        final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1ObjectIdentifier.createPrimitive(dEROctetString.string, false);
        }
    };
    private static final ConcurrentMap<OidHandle, ASN1ObjectIdentifier> pool = new ConcurrentHashMap<OidHandle, ASN1ObjectIdentifier>();
    private final String identifier;
    private byte[] contents;

    public static ASN1ObjectIdentifier getInstance$31c7e78d(ASN1Encodable aSN1Encodable) {
        ASN1Primitive aSN1Primitive;
        if (aSN1Encodable == null || aSN1Encodable instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)aSN1Encodable;
        }
        if (aSN1Encodable instanceof ASN1Encodable && (aSN1Primitive = aSN1Encodable.toASN1Primitive()) instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)aSN1Primitive;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + aSN1Encodable.getClass().getName());
    }

    private ASN1ObjectIdentifier(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        BigInteger bigInteger = null;
        boolean bl2 = true;
        for (int i = 0; i != byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (l <= 0xFFFFFFFFFFFF80L) {
                l += (long)(n & 0x7F);
                if ((n & 0x80) == 0) {
                    if (bl2) {
                        if (l < 40L) {
                            stringBuffer.append('0');
                        } else if (l < 80L) {
                            stringBuffer.append('1');
                            l -= 40L;
                        } else {
                            stringBuffer.append('2');
                            l -= 80L;
                        }
                        bl2 = false;
                    }
                    stringBuffer.append('.');
                    stringBuffer.append(l);
                    l = 0L;
                    continue;
                }
                l <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n & 0x7F));
            if ((n & 0x80) == 0) {
                if (bl2) {
                    stringBuffer.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl2 = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(bigInteger);
                bigInteger = null;
                l = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.identifier = stringBuffer.toString();
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public ASN1ObjectIdentifier(String string) {
        char c;
        String string2 = string;
        if (!(string2.length() < 3 || string2.charAt(1) != '.' ? false : ((c = string2.charAt(0)) < '0' || c > '2' ? false : ASN1RelativeOID.isValidIdentifier(string2, 2)))) {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.identifier = string;
    }

    private ASN1ObjectIdentifier(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (!ASN1RelativeOID.isValidIdentifier(string, 0)) {
            throw new IllegalArgumentException("string " + string + " not a valid OID branch");
        }
        this.identifier = aSN1ObjectIdentifier.identifier + "." + string;
    }

    public final ASN1ObjectIdentifier branch(String string) {
        return new ASN1ObjectIdentifier(this, string);
    }

    public final boolean on(ASN1ObjectIdentifier object) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this;
        String string = aSN1ObjectIdentifier.identifier;
        aSN1ObjectIdentifier = object;
        object = aSN1ObjectIdentifier.identifier;
        return string.length() > ((String)object).length() && string.charAt(((String)object).length()) == '.' && string.startsWith((String)object);
    }

    private synchronized byte[] getContents() {
        if (this.contents == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
            Object object = this;
            object = new OIDTokenizer(((ASN1ObjectIdentifier)object).identifier);
            int n = Integer.parseInt(((OIDTokenizer)object).nextToken()) * 40;
            String string = ((OIDTokenizer)object).nextToken();
            if (string.length() <= 18) {
                ASN1RelativeOID.writeField(byteArrayOutputStream2, (long)n + Long.parseLong(string));
            } else {
                ASN1RelativeOID.writeField(byteArrayOutputStream2, new BigInteger(string).add(BigInteger.valueOf(n)));
            }
            while (((OIDTokenizer)object).hasMoreTokens()) {
                String string2 = ((OIDTokenizer)object).nextToken();
                if (string2.length() <= 18) {
                    ASN1RelativeOID.writeField(byteArrayOutputStream2, Long.parseLong(string2));
                    continue;
                }
                ASN1RelativeOID.writeField(byteArrayOutputStream2, new BigInteger(string2));
            }
            this.contents = byteArrayOutputStream.toByteArray();
        }
        return this.contents;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.getContents().length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 6, this.getContents());
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive == this) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((ASN1ObjectIdentifier)aSN1Primitive).identifier);
    }

    public String toString() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this;
        return aSN1ObjectIdentifier.identifier;
    }

    public final ASN1ObjectIdentifier intern() {
        OidHandle oidHandle = new OidHandle(this.getContents());
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)pool.get(oidHandle);
        if (aSN1ObjectIdentifier == null && (aSN1ObjectIdentifier = pool.putIfAbsent(oidHandle, this)) == null) {
            aSN1ObjectIdentifier = this;
        }
        return aSN1ObjectIdentifier;
    }

    static ASN1ObjectIdentifier createPrimitive(byte[] byArray, boolean bl) {
        Object object = new OidHandle(byArray);
        if ((object = (ASN1ObjectIdentifier)pool.get(object)) == null) {
            return new ASN1ObjectIdentifier(byArray, bl);
        }
        return object;
    }

    private static final class OidHandle {
        private final int key;
        private final byte[] contents;

        OidHandle(byte[] byArray) {
            this.key = Arrays.hashCode(byArray);
            this.contents = byArray;
        }

        public final int hashCode() {
            return this.key;
        }

        public final boolean equals(Object object) {
            if (object instanceof OidHandle) {
                byte[] byArray = ((OidHandle)object).contents;
                object = this.contents;
                return java.util.Arrays.equals(this.contents, byArray);
            }
            return false;
        }
    }
}

