/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public abstract class ASN1OctetString
extends ASN1Primitive
implements ASN1OctetStringParser {
    static final 1 TYPE$2098b15f = new ASN1UniversalType(ASN1OctetString.class, 4){

        final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return dEROctetString;
        }

        final ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.toASN1OctetString();
        }
    };
    static final byte[] EMPTY_OCTETS = new byte[0];
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1OctetString)TYPE$2098b15f.getContextInstance(aSN1TaggedObject, bl);
    }

    public static ASN1OctetString getInstance(Object object) {
        if (object == null || object instanceof ASN1OctetString) {
            return (ASN1OctetString)object;
        }
        if (object instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1OctetString) {
                return (ASN1OctetString)aSN1Primitive;
            }
        } else if (object instanceof byte[]) {
            try {
                return (ASN1OctetString)TYPE$2098b15f.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct OCTET STRING from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public ASN1OctetString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = byArray;
    }

    public final InputStream getOctetStream() {
        return new ByteArrayInputStream(this.string);
    }

    public final byte[] getOctets() {
        return this.string;
    }

    public int hashCode() {
        ASN1OctetString aSN1OctetString = this;
        return Arrays.hashCode(aSN1OctetString.string);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1OctetString)) {
            return false;
        }
        object = (ASN1OctetString)object;
        byte[] byArray = ((ASN1OctetString)object).string;
        object = this.string;
        return java.util.Arrays.equals(this.string, byArray);
    }

    public final ASN1Primitive getLoadedObject() {
        return ((ASN1Object)this).toASN1Primitive();
    }

    ASN1Primitive toDERObject() {
        return new DEROctetString(this.string);
    }

    ASN1Primitive toDLObject() {
        return new DEROctetString(this.string);
    }

    public String toString() {
        return "#" + Strings.fromByteArray(Hex.encode(this.string));
    }

    static DEROctetString createPrimitive$71f4784c(byte[] byArray) {
        return new DEROctetString(byArray);
    }
}

