/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1PrintableString
extends ASN1Primitive {
    private byte[] contents;

    ASN1PrintableString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 19, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1PrintableString)) {
            return false;
        }
        object = (ASN1PrintableString)object;
        byte[] byArray = ((ASN1PrintableString)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public String toString() {
        ASN1PrintableString aSN1PrintableString = this;
        return Strings.fromByteArray(aSN1PrintableString.contents);
    }

    static DERPrintableString createPrimitive$2dffd114(byte[] byArray) {
        return new DERPrintableString(byArray, false);
    }

    static {
        new ASN1UniversalType(ASN1PrintableString.class, 19){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1PrintableString.createPrimitive$2dffd114(dEROctetString.string);
            }
        };
    }
}

