/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1External;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASN1Sequence
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    private static 1 TYPE$2098b15f = new ASN1UniversalType(ASN1Sequence.class, 16){

        final ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence;
        }
    };
    ASN1Encodable[] elements;

    public static ASN1Sequence getInstance(Object object) {
        if (object == null || object instanceof ASN1Sequence) {
            return (ASN1Sequence)object;
        }
        if (object instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Sequence) {
                return (ASN1Sequence)aSN1Primitive;
            }
        } else if (object instanceof byte[]) {
            try {
                return (ASN1Sequence)TYPE$2098b15f.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    protected ASN1Sequence() {
        this.elements = ASN1EncodableVector.EMPTY_ELEMENTS;
    }

    protected ASN1Sequence(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable == null) {
            throw new NullPointerException("'element' cannot be null");
        }
        this.elements = new ASN1Encodable[]{aSN1Encodable};
    }

    protected ASN1Sequence(ASN1EncodableVector aSN1EncodableVector) {
        if (aSN1EncodableVector == null) {
            throw new NullPointerException("'elementVector' cannot be null");
        }
        this.elements = aSN1EncodableVector.takeElements();
    }

    ASN1Sequence(ASN1Encodable[] aSN1EncodableArray, boolean bl) {
        this.elements = bl ? ASN1EncodableVector.cloneElements(aSN1EncodableArray) : aSN1EncodableArray;
    }

    ASN1Encodable[] toArrayInternal() {
        return this.elements;
    }

    public Enumeration getObjects() {
        return new Enumeration(this){
            private int pos = 0;
            private /* synthetic */ ASN1Sequence this$0;
            {
                this.this$0 = aSN1Sequence;
            }

            public final boolean hasMoreElements() {
                return this.pos < this.this$0.elements.length;
            }

            public final Object nextElement() {
                if (this.pos < this.this$0.elements.length) {
                    return this.this$0.elements[this.pos++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ASN1Encodable getObjectAt(int n) {
        return this.elements[n];
    }

    public int size() {
        return this.elements.length;
    }

    @Override
    public int hashCode() {
        int n = this.elements.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= this.elements[n].toASN1Primitive().hashCode();
        }
        return n2;
    }

    @Override
    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Sequence)) {
            return false;
        }
        aSN1Primitive = (ASN1Sequence)aSN1Primitive;
        int n = this.size();
        if (((ASN1Sequence)aSN1Primitive).size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            ASN1Primitive aSN1Primitive2;
            ASN1Primitive aSN1Primitive3 = this.elements[i].toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = ((ASN1Sequence)aSN1Primitive).elements[i].toASN1Primitive()) || aSN1Primitive3.asn1Equals(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERSequence(this.elements, false);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLSequence(this.elements, false);
    }

    abstract ASN1BitString toASN1BitString();

    abstract ASN1External toASN1External();

    abstract ASN1OctetString toASN1OctetString();

    abstract ASN1Set toASN1Set();

    @Override
    final boolean encodeConstructed() {
        return true;
    }

    public String toString() {
        int n = this.size();
        if (n == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n2 = 0;
        while (true) {
            stringBuffer.append(this.elements[n2]);
            if (++n2 >= n) break;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator(this.elements);
    }

    final ASN1BitString[] getConstructedBitStrings() {
        int n = this.size();
        ASN1BitString[] aSN1BitStringArray = new ASN1BitString[n];
        for (int i = 0; i < n; ++i) {
            aSN1BitStringArray[i] = ASN1BitString.getInstance$7c1c9dd(this.elements[i]);
        }
        return aSN1BitStringArray;
    }

    final ASN1OctetString[] getConstructedOctetStrings() {
        int n = this.size();
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[n];
        for (int i = 0; i < n; ++i) {
            aSN1OctetStringArray[i] = ASN1OctetString.getInstance(this.elements[i]);
        }
        return aSN1OctetStringArray;
    }
}

