/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASN1Set
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    private static 1 TYPE$2098b15f = new ASN1UniversalType(ASN1Set.class, 17){

        final ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.toASN1Set();
        }
    };
    protected final ASN1Encodable[] elements;
    protected final boolean isSorted;

    public static ASN1Set getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1Set)TYPE$2098b15f.getContextInstance(aSN1TaggedObject, false);
    }

    protected ASN1Set() {
        this.elements = ASN1EncodableVector.EMPTY_ELEMENTS;
        this.isSorted = true;
    }

    protected ASN1Set(ASN1EncodableVector aSN1EncodableArray, boolean bl) {
        if (aSN1EncodableArray == null) {
            throw new NullPointerException("'elementVector' cannot be null");
        }
        aSN1EncodableArray = aSN1EncodableArray.takeElements();
        this.elements = aSN1EncodableArray;
        this.isSorted = aSN1EncodableArray.length < 2;
    }

    ASN1Set(boolean bl, ASN1Encodable[] aSN1EncodableArray) {
        this.elements = aSN1EncodableArray;
        this.isSorted = bl || aSN1EncodableArray.length < 2;
    }

    @Override
    public int hashCode() {
        int n = this.elements.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 += this.elements[n].toASN1Primitive().hashCode();
        }
        return n2;
    }

    @Override
    ASN1Primitive toDERObject() {
        ASN1Encodable[] aSN1EncodableArray;
        if (this.isSorted) {
            aSN1EncodableArray = this.elements;
        } else {
            aSN1EncodableArray = (ASN1Encodable[])this.elements.clone();
            ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
            int n = aSN1EncodableArray.length;
            if (n >= 2) {
                Object object;
                Object object2 = aSN1EncodableArray2[0];
                Object object3 = aSN1EncodableArray2[1];
                byte[] byArray = ASN1Set.getDEREncoded((ASN1Encodable)object2);
                byte[] byArray2 = ASN1Set.getDEREncoded((ASN1Encodable)object3);
                if (ASN1Set.lessThanOrEqual(byArray2, byArray)) {
                    ASN1Encodable aSN1Encodable = object3;
                    object3 = object2;
                    object2 = aSN1Encodable;
                    object = byArray2;
                    byArray2 = byArray;
                    byArray = object;
                }
                for (int i = 2; i < n; ++i) {
                    ASN1Encodable aSN1Encodable;
                    byte[] byArray3;
                    ASN1Encodable aSN1Encodable2 = aSN1EncodableArray2[i];
                    object = aSN1Encodable2;
                    byte[] byArray4 = ASN1Set.getDEREncoded(aSN1Encodable2);
                    if (ASN1Set.lessThanOrEqual(byArray2, byArray4)) {
                        aSN1EncodableArray2[i - 2] = object2;
                        object2 = object3;
                        byArray = byArray2;
                        object3 = object;
                        byArray2 = byArray4;
                        continue;
                    }
                    if (ASN1Set.lessThanOrEqual(byArray, byArray4)) {
                        aSN1EncodableArray2[i - 2] = object2;
                        object2 = object;
                        byArray = byArray4;
                        continue;
                    }
                    int n2 = i - 1;
                    while (--n2 > 0 && !ASN1Set.lessThanOrEqual(byArray3 = ASN1Set.getDEREncoded(aSN1Encodable = aSN1EncodableArray2[n2 - 1]), byArray4)) {
                        aSN1EncodableArray2[n2] = aSN1Encodable;
                    }
                    aSN1EncodableArray2[n2] = object;
                }
                aSN1EncodableArray2[n - 2] = object2;
                aSN1EncodableArray2[n - 1] = object3;
            }
        }
        return new DERSet(true, aSN1EncodableArray);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLSet(this.isSorted, this.elements);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Set)) {
            return false;
        }
        aSN1Primitive = (ASN1Set)aSN1Primitive;
        ASN1Primitive aSN1Primitive2 = this;
        int n = aSN1Primitive2.elements.length;
        aSN1Primitive2 = aSN1Primitive;
        if (aSN1Primitive2.elements.length != n) {
            return false;
        }
        aSN1Primitive2 = (DERSet)this.toDERObject();
        aSN1Primitive = (DERSet)((ASN1Set)aSN1Primitive).toDERObject();
        for (int i = 0; i < n; ++i) {
            ASN1Primitive aSN1Primitive3;
            ASN1Primitive aSN1Primitive4 = aSN1Primitive2.elements[i].toASN1Primitive();
            if (aSN1Primitive4 == (aSN1Primitive3 = ((ASN1Set)aSN1Primitive).elements[i].toASN1Primitive()) || aSN1Primitive4.asn1Equals(aSN1Primitive3)) continue;
            return false;
        }
        return true;
    }

    @Override
    final boolean encodeConstructed() {
        return true;
    }

    public String toString() {
        ASN1Set aSN1Set = this;
        int n = aSN1Set.elements.length;
        if (n == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n2 = 0;
        while (true) {
            stringBuffer.append(this.elements[n2]);
            if (++n2 >= n) break;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Iterator<ASN1Encodable> iterator() {
        ASN1Set aSN1Set = this;
        return new Arrays.Iterator(ASN1EncodableVector.cloneElements(aSN1Set.elements));
    }

    private static byte[] getDEREncoded(ASN1Encodable aSN1Encodable) {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    private static boolean lessThanOrEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray[0] & 0xFFFFFFDF;
        int n2 = byArray2[0] & 0xFFFFFFDF;
        if (n != n2) {
            return n < n2;
        }
        n = Math.min(byArray.length, byArray2.length) - 1;
        for (n2 = 1; n2 < n; ++n2) {
            if (byArray[n2] == byArray2[n2]) continue;
            return (byArray[n2] & 0xFF) < (byArray2[n2] & 0xFF);
        }
        return (byArray[n] & 0xFF) <= (byArray2[n] & 0xFF);
    }
}

