/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class ASN1UTCTime
extends ASN1Primitive {
    private byte[] contents;

    private ASN1UTCTime(byte[] byArray) {
        if (byArray.length < 2) {
            throw new IllegalArgumentException("UTCTime string too short");
        }
        this.contents = byArray;
        if (!this.isDigit(0) || !this.isDigit(1)) {
            throw new IllegalArgumentException("illegal characters in UTCTime string");
        }
    }

    private boolean isDigit(int n) {
        return this.contents.length > n && this.contents[n] >= 48 && this.contents[n] <= 57;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 23, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1UTCTime)) {
            return false;
        }
        byte[] byArray = ((ASN1UTCTime)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public String toString() {
        return Strings.fromByteArray(this.contents);
    }

    static ASN1UTCTime createPrimitive(byte[] byArray) {
        return new ASN1UTCTime(byArray);
    }

    static {
        new ASN1UniversalType(ASN1UTCTime.class, 23){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1UTCTime.createPrimitive(dEROctetString.string);
            }
        };
    }
}

