/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1UTF8String
extends ASN1Primitive {
    private byte[] contents;

    ASN1UTF8String(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public String toString() {
        ASN1UTF8String aSN1UTF8String = this;
        return Strings.fromUTF8ByteArray(aSN1UTF8String.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1UTF8String)) {
            return false;
        }
        object = (ASN1UTF8String)object;
        byte[] byArray = ((ASN1UTF8String)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 12, this.contents);
    }

    static DERUTF8String createPrimitive$b3390a8(byte[] byArray) {
        return new DERUTF8String(byArray, false);
    }

    static {
        new ASN1UniversalType(ASN1UTF8String.class, 12){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1UTF8String.createPrimitive$b3390a8(dEROctetString.string);
            }
        };
    }
}

