/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEROctetString;

public final class BEROctetString
extends ASN1OctetString {
    private final int segmentLimit;
    private final ASN1OctetString[] elements;

    static byte[] flattenOctetStrings(ASN1OctetString[] aSN1OctetStringArray) {
        int n = aSN1OctetStringArray.length;
        switch (n) {
            case 0: {
                return EMPTY_OCTETS;
            }
            case 1: {
                return aSN1OctetStringArray[0].string;
            }
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += aSN1OctetStringArray[i].string.length;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            byte[] byArray2 = aSN1OctetStringArray[n2].string;
            System.arraycopy(aSN1OctetStringArray[n2].string, 0, byArray, n3, byArray2.length);
            n3 += byArray2.length;
        }
        return byArray;
    }

    public BEROctetString(byte[] byArray) {
        this(byArray, 1000);
    }

    public BEROctetString(ASN1OctetString[] aSN1OctetStringArray) {
        this(aSN1OctetStringArray, 1000);
    }

    private BEROctetString(byte[] byArray, int n) {
        this(byArray, null, 1000);
    }

    private BEROctetString(ASN1OctetString[] aSN1OctetStringArray, int n) {
        this(BEROctetString.flattenOctetStrings(aSN1OctetStringArray), aSN1OctetStringArray, 1000);
    }

    private BEROctetString(byte[] byArray, ASN1OctetString[] aSN1OctetStringArray, int n) {
        super(byArray);
        this.elements = aSN1OctetStringArray;
        this.segmentLimit = n;
    }

    final boolean encodeConstructed() {
        return this.elements != null || this.string.length > this.segmentLimit;
    }

    /*
     * WARNING - void declaration
     */
    final int encodedLength(boolean bl) throws IOException {
        void var1_9;
        int n;
        if (!this.encodeConstructed()) {
            int n2 = this.string.length;
            boolean bl2 = bl;
            return ASN1OutputStream.getLengthOfEncodingDL(bl2, n2);
        }
        int n3 = n = bl ? 4 : 3;
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                var1_4 += this.elements[i].encodedLength(true);
            }
        } else {
            int n4 = this.string.length / this.segmentLimit;
            int n5 = this.segmentLimit;
            boolean bl3 = true;
            int n6 = n + n4 * ASN1OutputStream.getLengthOfEncodingDL(true, n5);
            if ((n4 = this.string.length - n4 * this.segmentLimit) > 0) {
                n5 = n4;
                boolean bl4 = true;
                int n7 = n6 + ASN1OutputStream.getLengthOfEncodingDL(true, n5);
            }
        }
        return (int)var1_9;
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean n) throws IOException {
        if (!this.encodeConstructed()) {
            DEROctetString.encode(aSN1OutputStream, n != 0, this.string, 0, this.string.length);
            return;
        }
        aSN1OutputStream.writeIdentifier(n != 0, 36);
        aSN1OutputStream.write(128);
        if (this.elements != null) {
            aSN1OutputStream.writePrimitives(this.elements);
        } else {
            int n2;
            for (n = 0; n < this.string.length; n += n2) {
                n2 = Math.min(this.string.length - n, this.segmentLimit);
                DEROctetString.encode(aSN1OutputStream, true, this.string, n, n2);
            }
        }
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }
}

