/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;

public final class BERTaggedObject
extends ASN1TaggedObject {
    BERTaggedObject(int n, int n2, int n3, ASN1Encodable aSN1Encodable) {
        super(n, n2, n3, aSN1Encodable);
    }

    final boolean encodeConstructed() {
        return this.isExplicit() || this.obj.toASN1Primitive().encodeConstructed();
    }

    final int encodedLength(boolean bl) throws IOException {
        ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive();
        boolean bl2 = this.isExplicit();
        int n = aSN1Primitive.encodedLength(bl2);
        if (bl2) {
            n += 3;
        }
        return n += bl ? ASN1OutputStream.getLengthOfIdentifier(this.tagNo) : 0;
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive();
        boolean bl2 = this.isExplicit();
        if (bl) {
            int n;
            int n2 = this.tagClass;
            if (bl2 || aSN1Primitive.encodeConstructed()) {
                n = n2 | 0x20;
            }
            aSN1OutputStream.writeIdentifier(true, n, this.tagNo);
        }
        if (bl2) {
            aSN1OutputStream.write(128);
            aSN1Primitive.encode(aSN1OutputStream, true);
            aSN1OutputStream.write(0);
            aSN1OutputStream.write(0);
            return;
        }
        aSN1Primitive.encode(aSN1OutputStream, false);
    }

    final ASN1Sequence rebuildConstructed(ASN1Primitive aSN1Primitive) {
        return new BERSequence(aSN1Primitive);
    }
}

