/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitStringParser;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.asn1.DefiniteLengthInputStream;

public final class DLBitStringParser
implements ASN1BitStringParser {
    private final DefiniteLengthInputStream stream;
    private int padBits = 0;

    DLBitStringParser(DefiniteLengthInputStream definiteLengthInputStream) {
        this.stream = definiteLengthInputStream;
    }

    public final InputStream getBitStream() throws IOException {
        boolean bl = false;
        DLBitStringParser dLBitStringParser = this;
        int n = dLBitStringParser.stream.getRemaining();
        if (n <= 0) {
            throw new IllegalStateException("content octets cannot be empty");
        }
        dLBitStringParser.padBits = dLBitStringParser.stream.read();
        if (dLBitStringParser.padBits > 0) {
            if (n < 2) {
                throw new IllegalStateException("zero length data with non-zero pad bits");
            }
            if (dLBitStringParser.padBits > 7) {
                throw new IllegalStateException("pad bits cannot be greater than 7 or less than 0");
            }
        }
        return dLBitStringParser.stream;
    }

    public final int getPadBits() {
        return this.padBits;
    }

    public final ASN1Primitive getLoadedObject() throws IOException {
        return DLBitString.createPrimitive(this.stream.toByteArray());
    }

    public final ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("IOException converting stream to byte array: " + iOException.getMessage(), iOException);
        }
    }
}

