/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DLOutputStream;

public final class DLSet
extends ASN1Set {
    private int contentsLength = -1;

    public DLSet() {
    }

    public DLSet(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector, false);
    }

    DLSet(boolean bl, ASN1Encodable[] aSN1EncodableArray) {
        super(bl, aSN1EncodableArray);
    }

    private int getContentsLength() throws IOException {
        if (this.contentsLength < 0) {
            int n = this.elements.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                ASN1Primitive aSN1Primitive = this.elements[i].toASN1Primitive().toDLObject();
                n2 += aSN1Primitive.encodedLength(true);
            }
            this.contentsLength = n2;
        }
        return this.contentsLength;
    }

    final int encodedLength(boolean bl) throws IOException {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.getContentsLength());
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        int n;
        aSN1OutputStream.writeIdentifier(bl, 49);
        DLOutputStream dLOutputStream = aSN1OutputStream.getDLSubStream();
        int n2 = this.elements.length;
        if (this.contentsLength >= 0 || n2 > 16) {
            aSN1OutputStream.writeDL(this.getContentsLength());
            for (int i = 0; i < n2; ++i) {
                ((ASN1OutputStream)dLOutputStream).writePrimitive(this.elements[i].toASN1Primitive(), true);
            }
            return;
        }
        int n3 = 0;
        ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[n2];
        for (n = 0; n < n2; ++n) {
            ASN1Primitive aSN1Primitive;
            aSN1PrimitiveArray[n] = aSN1Primitive = this.elements[n].toASN1Primitive().toDLObject();
            n3 += aSN1Primitive.encodedLength(true);
        }
        this.contentsLength = n3;
        aSN1OutputStream.writeDL(n3);
        for (n = 0; n < n2; ++n) {
            ((ASN1OutputStream)dLOutputStream).writePrimitive(aSN1PrimitiveArray[n], true);
        }
    }

    final ASN1Primitive toDLObject() {
        return this;
    }
}

