/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.BigIntegers;

public final class PrivateKeyInfo
extends ASN1Object {
    private ASN1Integer version;
    private AlgorithmIdentifier privateKeyAlgorithm;
    private ASN1OctetString privateKey;
    private ASN1Set attributes;
    private DERBitString publicKey$2fc4018;

    public static PrivateKeyInfo getInstance$57c4e802(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive != null) {
            return new PrivateKeyInfo(ASN1Sequence.getInstance(aSN1Primitive));
        }
        return null;
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws IOException {
        this(algorithmIdentifier, aSN1Object, null, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object, ASN1Set aSN1Set) throws IOException {
        this(algorithmIdentifier, aSN1Object, aSN1Set, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable, ASN1Set aSN1Set, byte[] byArray) throws IOException {
        this.version = new ASN1Integer(byArray != null ? BigIntegers.ONE : BigIntegers.ZERO);
        this.privateKeyAlgorithm = algorithmIdentifier;
        this.privateKey = new DEROctetString(aSN1Encodable);
        this.attributes = aSN1Set;
        this.publicKey$2fc4018 = byArray == null ? null : new DERBitString(byArray);
    }

    private PrivateKeyInfo(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        ASN1Integer aSN1Integer = this.version = ASN1Integer.getInstance(object.nextElement());
        int n = aSN1Integer.intValueExact();
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("invalid version for private key info");
        }
        this.privateKeyAlgorithm = AlgorithmIdentifier.getInstance(object.nextElement());
        this.privateKey = ASN1OctetString.getInstance(object.nextElement());
        int n2 = -1;
        block4: while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
            int n3 = aSN1TaggedObject.getTagNo();
            if (n3 <= n2) {
                throw new IllegalArgumentException("invalid optional field in private key info");
            }
            n2 = n3;
            switch (n3) {
                case 0: {
                    this.attributes = ASN1Set.getInstance(aSN1TaggedObject, false);
                    continue block4;
                }
                case 1: {
                    if (n <= 0) {
                        throw new IllegalArgumentException("'publicKey' requires version v2(1) or later");
                    }
                    this.publicKey$2fc4018 = DERBitString.getInstance(aSN1TaggedObject, false);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unknown optional field in private key info");
        }
    }

    public final ASN1Set getAttributes() {
        return this.attributes;
    }

    public final AlgorithmIdentifier getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public final ASN1Primitive parsePrivateKey$7b6dd9a4() throws IOException {
        return ASN1Primitive.fromByteArray(this.privateKey.getOctets());
    }

    public final ASN1BitString getPublicKeyData() {
        return this.publicKey$2fc4018;
    }

    public final ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(5);
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.privateKeyAlgorithm);
        aSN1EncodableVector.add(this.privateKey);
        if (this.attributes != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.attributes));
        }
        if (this.publicKey$2fc4018 != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.publicKey$2fc4018));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

