/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class SubjectPublicKeyInfo
extends ASN1Object {
    private AlgorithmIdentifier algId;
    private DERBitString keyData$2fc4018;

    public static SubjectPublicKeyInfo getInstance(Object object) {
        if (object instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)object;
        }
        if (object != null) {
            return new SubjectPublicKeyInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        this.keyData$2fc4018 = new DERBitString(aSN1Encodable);
        this.algId = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.keyData$2fc4018 = new DERBitString(byArray);
        this.algId = algorithmIdentifier;
    }

    private SubjectPublicKeyInfo(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + ((ASN1Sequence)object).size());
        }
        object = ((ASN1Sequence)object).getObjects();
        this.algId = AlgorithmIdentifier.getInstance(object.nextElement());
        this.keyData$2fc4018 = DERBitString.getInstance(object.nextElement());
    }

    public final AlgorithmIdentifier getAlgorithm() {
        return this.algId;
    }

    public final ASN1Primitive parsePublicKey() throws IOException {
        return ASN1Primitive.fromByteArray(this.keyData$2fc4018.getOctets());
    }

    public final ASN1BitString getPublicKeyData() {
        return this.keyData$2fc4018;
    }

    public final ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.algId);
        aSN1EncodableVector.add(this.keyData$2fc4018);
        return new DERSequence(aSN1EncodableVector);
    }
}

