/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public final class GOST3411Digest
implements ExtendedDigest,
Memoable {
    private byte[] H = new byte[32];
    private byte[] L = new byte[32];
    private byte[] M = new byte[32];
    private byte[] Sum = new byte[32];
    private byte[][] C = new byte[4][32];
    private byte[] xBuf = new byte[32];
    private int xBufOff;
    private long byteCount;
    private GOST28147Engine cipher$7509190d = new GOST28147Engine();
    private byte[] sBox;
    private byte[] K = new byte[32];
    private byte[] a = new byte[8];
    private short[] wS = new short[16];
    private short[] w_S = new short[16];
    private byte[] S = new byte[32];
    private byte[] U = new byte[32];
    private byte[] V = new byte[32];
    private byte[] W = new byte[32];
    private static final byte[] C2 = new byte[]{0, -1, 0, -1, 0, -1, 0, -1, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1};

    public GOST3411Digest() {
        this.sBox = GOST28147Engine.getSBox("D-A");
        this.cipher$7509190d.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
    }

    private GOST3411Digest(GOST3411Digest gOST3411Digest) {
        this.reset(gOST3411Digest);
    }

    public final String getAlgorithmName() {
        return "GOST3411";
    }

    public final int getDigestSize() {
        return 32;
    }

    public final void update(byte by) {
        this.xBuf[this.xBufOff++] = by;
        if (this.xBufOff == this.xBuf.length) {
            GOST3411Digest gOST3411Digest = this;
            gOST3411Digest.sumByteArray(gOST3411Digest.xBuf);
            GOST3411Digest gOST3411Digest2 = this;
            gOST3411Digest2.processBlock(gOST3411Digest2.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public final void update(byte[] byArray, int n, int n2) {
        while (this.xBufOff != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 > this.xBuf.length) {
            System.arraycopy(byArray, n, this.xBuf, 0, this.xBuf.length);
            GOST3411Digest gOST3411Digest = this;
            gOST3411Digest.sumByteArray(gOST3411Digest.xBuf);
            GOST3411Digest gOST3411Digest2 = this;
            gOST3411Digest2.processBlock(gOST3411Digest2.xBuf, 0);
            n += this.xBuf.length;
            n2 -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }

    private byte[] P(byte[] byArray) {
        for (int i = 0; i < 8; ++i) {
            this.K[4 * i] = byArray[i];
            this.K[1 + 4 * i] = byArray[i + 8];
            this.K[2 + 4 * i] = byArray[i + 16];
            this.K[3 + 4 * i] = byArray[i + 24];
        }
        return this.K;
    }

    private byte[] A(byte[] byArray) {
        for (int i = 0; i < 8; ++i) {
            this.a[i] = (byte)(byArray[i] ^ byArray[i + 8]);
        }
        System.arraycopy(byArray, 8, byArray, 0, 24);
        System.arraycopy(this.a, 0, byArray, 24, 8);
        return byArray;
    }

    private void E(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2) {
        this.cipher$7509190d.init(true, new KeyParameter(byArray));
        this.cipher$7509190d.processBlock(byArray3, n2, byArray2, n);
    }

    private void fw(byte[] byArray) {
        int n;
        Object[] objectArray = this.wS;
        Object[] objectArray2 = byArray;
        for (n = 0; n < objectArray2.length / 2; ++n) {
            objectArray[n] = (short)(objectArray2[(n << 1) + 1] << 8 & 0xFF00 | objectArray2[n << 1] & 0xFF);
        }
        this.w_S[15] = (short)(this.wS[0] ^ this.wS[1] ^ this.wS[2] ^ this.wS[3] ^ this.wS[12] ^ this.wS[15]);
        System.arraycopy(this.wS, 1, this.w_S, 0, 15);
        objectArray = byArray;
        objectArray2 = this.w_S;
        for (n = 0; n < objectArray.length / 2; ++n) {
            objectArray[(n << 1) + 1] = (byte)(objectArray2[n] >> 8);
            objectArray[n << 1] = objectArray2[n];
        }
    }

    private void processBlock(byte[] byArray, int n) {
        int n2;
        System.arraycopy(byArray, 0, this.M, 0, 32);
        System.arraycopy(this.H, 0, this.U, 0, 32);
        System.arraycopy(this.M, 0, this.V, 0, 32);
        for (n2 = 0; n2 < 32; ++n2) {
            this.W[n2] = (byte)(this.U[n2] ^ this.V[n2]);
        }
        GOST3411Digest gOST3411Digest = this;
        gOST3411Digest.E(gOST3411Digest.P(this.W), this.S, 0, this.H, 0);
        for (n2 = 1; n2 < 4; ++n2) {
            int n3;
            GOST3411Digest gOST3411Digest2 = this;
            byte[] byArray2 = gOST3411Digest2.A(gOST3411Digest2.U);
            for (n3 = 0; n3 < 32; ++n3) {
                this.U[n3] = (byte)(byArray2[n3] ^ this.C[n2][n3]);
            }
            GOST3411Digest gOST3411Digest3 = this;
            this.V = this.A(gOST3411Digest3.A(gOST3411Digest3.V));
            for (n3 = 0; n3 < 32; ++n3) {
                this.W[n3] = (byte)(this.U[n3] ^ this.V[n3]);
            }
            GOST3411Digest gOST3411Digest4 = this;
            gOST3411Digest4.E(gOST3411Digest4.P(this.W), this.S, n2 << 3, this.H, n2 << 3);
        }
        for (n2 = 0; n2 < 12; ++n2) {
            GOST3411Digest gOST3411Digest5 = this;
            gOST3411Digest5.fw(gOST3411Digest5.S);
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.S[n2] = (byte)(this.S[n2] ^ this.M[n2]);
        }
        GOST3411Digest gOST3411Digest6 = this;
        gOST3411Digest6.fw(gOST3411Digest6.S);
        for (n2 = 0; n2 < 32; ++n2) {
            this.S[n2] = (byte)(this.H[n2] ^ this.S[n2]);
        }
        for (n2 = 0; n2 < 61; ++n2) {
            GOST3411Digest gOST3411Digest7 = this;
            gOST3411Digest7.fw(gOST3411Digest7.S);
        }
        System.arraycopy(this.S, 0, this.H, 0, this.H.length);
    }

    public final int doFinal(byte[] byArray, int n) {
        GOST3411Digest gOST3411Digest = this;
        Pack.longToLittleEndian(gOST3411Digest.byteCount << 3, gOST3411Digest.L, 0);
        while (gOST3411Digest.xBufOff != 0) {
            gOST3411Digest.update((byte)0);
        }
        GOST3411Digest gOST3411Digest2 = gOST3411Digest;
        gOST3411Digest2.processBlock(gOST3411Digest2.L, 0);
        GOST3411Digest gOST3411Digest3 = gOST3411Digest;
        gOST3411Digest3.processBlock(gOST3411Digest3.Sum, 0);
        System.arraycopy(this.H, 0, byArray, n, this.H.length);
        this.reset();
        return 32;
    }

    public final void reset() {
        int n;
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (n = 0; n < this.H.length; ++n) {
            this.H[n] = 0;
        }
        for (n = 0; n < this.L.length; ++n) {
            this.L[n] = 0;
        }
        for (n = 0; n < this.M.length; ++n) {
            this.M[n] = 0;
        }
        for (n = 0; n < this.C[1].length; ++n) {
            this.C[1][n] = 0;
        }
        for (n = 0; n < this.C[3].length; ++n) {
            this.C[3][n] = 0;
        }
        for (n = 0; n < this.Sum.length; ++n) {
            this.Sum[n] = 0;
        }
        for (n = 0; n < this.xBuf.length; ++n) {
            this.xBuf[n] = 0;
        }
        System.arraycopy(C2, 0, this.C[2], 0, C2.length);
    }

    private void sumByteArray(byte[] byArray) {
        int n = 0;
        for (int i = 0; i != this.Sum.length; ++i) {
            n = (this.Sum[i] & 0xFF) + (byArray[i] & 0xFF) + n;
            this.Sum[i] = (byte)n;
            n >>>= 8;
        }
    }

    public final int getByteLength() {
        return 32;
    }

    public final Memoable copy() {
        return new GOST3411Digest(this);
    }

    public final void reset(Memoable memoable) {
        memoable = (GOST3411Digest)memoable;
        this.sBox = ((GOST3411Digest)memoable).sBox;
        this.cipher$7509190d.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
        System.arraycopy(((GOST3411Digest)memoable).H, 0, this.H, 0, ((GOST3411Digest)memoable).H.length);
        System.arraycopy(((GOST3411Digest)memoable).L, 0, this.L, 0, ((GOST3411Digest)memoable).L.length);
        System.arraycopy(((GOST3411Digest)memoable).M, 0, this.M, 0, ((GOST3411Digest)memoable).M.length);
        System.arraycopy(((GOST3411Digest)memoable).Sum, 0, this.Sum, 0, ((GOST3411Digest)memoable).Sum.length);
        System.arraycopy(((GOST3411Digest)memoable).C[1], 0, this.C[1], 0, ((GOST3411Digest)memoable).C[1].length);
        System.arraycopy(((GOST3411Digest)memoable).C[2], 0, this.C[2], 0, ((GOST3411Digest)memoable).C[2].length);
        System.arraycopy(((GOST3411Digest)memoable).C[3], 0, this.C[3], 0, ((GOST3411Digest)memoable).C[3].length);
        System.arraycopy(((GOST3411Digest)memoable).xBuf, 0, this.xBuf, 0, ((GOST3411Digest)memoable).xBuf.length);
        this.xBufOff = ((GOST3411Digest)memoable).xBufOff;
        this.byteCount = ((GOST3411Digest)memoable).byteCount;
    }
}

