/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.KeccakDigest;

public final class SHA3Digest
extends KeccakDigest {
    public SHA3Digest() {
        this(256);
    }

    public SHA3Digest(int n) {
        switch (n) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                break;
            }
            default: {
                throw new IllegalArgumentException("'bitLength' " + n + " not supported for SHA-3");
            }
        }
        super(n);
    }

    public final String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    public final int doFinal(byte[] byArray, int n) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n);
    }
}

