/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.LongDigest;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public final class SHA512Digest
extends LongDigest {
    public SHA512Digest() {
    }

    private SHA512Digest(SHA512Digest sHA512Digest) {
        super(sHA512Digest);
    }

    public final String getAlgorithmName() {
        return "SHA-512";
    }

    public final int getDigestSize() {
        return 64;
    }

    public final int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.longToBigEndian(this.H1, byArray, n);
        Pack.longToBigEndian(this.H2, byArray, n + 8);
        Pack.longToBigEndian(this.H3, byArray, n + 16);
        Pack.longToBigEndian(this.H4, byArray, n + 24);
        Pack.longToBigEndian(this.H5, byArray, n + 32);
        Pack.longToBigEndian(this.H6, byArray, n + 40);
        Pack.longToBigEndian(this.H7, byArray, n + 48);
        Pack.longToBigEndian(this.H8, byArray, n + 56);
        ((LongDigest)this).reset();
        return 64;
    }

    public final void reset() {
        super.reset();
        this.H1 = 7640891576956012808L;
        this.H2 = -4942790177534073029L;
        this.H3 = 4354685564936845355L;
        this.H4 = -6534734903238641935L;
        this.H5 = 5840696475078001361L;
        this.H6 = -7276294671716946913L;
        this.H7 = 2270897969802886507L;
        this.H8 = 6620516959819538809L;
    }

    public final Memoable copy() {
        return new SHA512Digest(this);
    }

    public final void reset(Memoable memoable) {
        memoable = (SHA512Digest)memoable;
        this.copyIn((LongDigest)memoable);
    }
}

