/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.KeccakDigest;

public final class SHAKEDigest
extends KeccakDigest
implements Xof {
    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(int n) {
        switch (n) {
            case 128: 
            case 256: {
                break;
            }
            default: {
                throw new IllegalArgumentException("'bitLength' " + n + " not supported for SHAKE");
            }
        }
        super(n);
    }

    public final String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    public final int getDigestSize() {
        return this.fixedOutputLength / 4;
    }

    public final int doFinal(byte[] object, int n) {
        byte[] byArray = object;
        SHAKEDigest sHAKEDigest = this;
        object = sHAKEDigest;
        return this.doFinal(byArray, n, sHAKEDigest.fixedOutputLength / 4);
    }

    public final int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    private int doOutput(byte[] byArray, int n, int n2) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        this.squeeze(byArray, n, (long)n2 << 3);
        return n2;
    }
}

