/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public final class SM3Digest
extends GeneralDigest {
    private int[] V = new int[8];
    private int[] inwords = new int[16];
    private int xOff;
    private int[] W = new int[68];
    private static final int[] T;

    public SM3Digest() {
        ((GeneralDigest)this).reset();
    }

    private SM3Digest(SM3Digest sM3Digest) {
        super(sM3Digest);
        this.copyIn(sM3Digest);
    }

    private void copyIn(SM3Digest sM3Digest) {
        System.arraycopy(sM3Digest.V, 0, this.V, 0, this.V.length);
        System.arraycopy(sM3Digest.inwords, 0, this.inwords, 0, this.inwords.length);
        this.xOff = sM3Digest.xOff;
    }

    public final String getAlgorithmName() {
        return "SM3";
    }

    public final int getDigestSize() {
        return 32;
    }

    public final Memoable copy() {
        return new SM3Digest(this);
    }

    public final void reset(Memoable memoable) {
        memoable = (SM3Digest)memoable;
        super.copyIn((GeneralDigest)memoable);
        this.copyIn((SM3Digest)memoable);
    }

    public final void reset() {
        super.reset();
        this.V[0] = 1937774191;
        this.V[1] = 1226093241;
        this.V[2] = 388252375;
        this.V[3] = -628488704;
        this.V[4] = -1452330820;
        this.V[5] = 372324522;
        this.V[6] = -477237683;
        this.V[7] = -1325724082;
        this.xOff = 0;
    }

    public final int doFinal(byte[] objectArray, int n) {
        this.finish();
        int n2 = n;
        byte[] byArray = objectArray;
        objectArray = this.V;
        for (int i = 0; i < objectArray.length; ++i) {
            Pack.intToBigEndian(objectArray[i], byArray, n2);
            n2 += 4;
        }
        ((GeneralDigest)this).reset();
        return 32;
    }

    protected final void processWord(byte[] byArray, int n) {
        int n2;
        this.inwords[this.xOff] = n2 = (byArray[n] & 0xFF) << 24 | (byArray[++n] & 0xFF) << 16 | (byArray[++n] & 0xFF) << 8 | byArray[++n] & 0xFF;
        ++this.xOff;
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    protected final void processLength(long l) {
        if (this.xOff > 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
            this.processBlock();
        }
        while (this.xOff < 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
        }
        this.inwords[this.xOff++] = (int)(l >>> 32);
        this.inwords[this.xOff++] = (int)l;
    }

    private static int P0(int n) {
        int n2 = n << 9 | n >>> 23;
        int n3 = n << 17 | n >>> 15;
        return n ^ n2 ^ n3;
    }

    private static int P1(int n) {
        int n2 = n << 15 | n >>> 17;
        int n3 = n << 23 | n >>> 9;
        return n ^ n2 ^ n3;
    }

    private static int FF1(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private static int GG1(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    protected final void processBlock() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        for (n10 = 0; n10 < 16; ++n10) {
            this.W[n10] = this.inwords[n10];
        }
        for (n10 = 16; n10 < 68; ++n10) {
            n9 = this.W[n10 - 3];
            n8 = n9 << 15 | n9 >>> 17;
            n7 = this.W[n10 - 13];
            n6 = n7 << 7 | n7 >>> 25;
            this.W[n10] = SM3Digest.P1(this.W[n10 - 16] ^ this.W[n10 - 9] ^ n8) ^ n6 ^ this.W[n10 - 6];
        }
        n10 = this.V[0];
        n9 = this.V[1];
        n8 = this.V[2];
        n7 = this.V[3];
        n6 = this.V[4];
        int n11 = this.V[5];
        int n12 = this.V[6];
        int n13 = this.V[7];
        for (n5 = 0; n5 < 16; ++n5) {
            n4 = n10 << 12 | n10 >>> 20;
            n3 = n4 + n6 + T[n5];
            n3 = n3 << 7 | n3 >>> 25;
            n4 = n3 ^ n4;
            n2 = this.W[n5];
            n = n2 ^ this.W[n5 + 4];
            int n14 = n8;
            int n15 = n9;
            int n16 = n10;
            n4 = (n16 ^ n15 ^ n14) + n7 + n4 + n;
            n14 = n12;
            n15 = n11;
            n16 = n6;
            n3 = (n16 ^ n15 ^ n14) + n13 + n3 + n2;
            n7 = n8;
            n8 = n9 << 9 | n9 >>> 23;
            n9 = n10;
            n10 = n4;
            n13 = n12;
            n12 = n11 << 19 | n11 >>> 13;
            n11 = n6;
            n6 = SM3Digest.P0(n3);
        }
        for (n5 = 16; n5 < 64; ++n5) {
            n4 = n10 << 12 | n10 >>> 20;
            n3 = n4 + n6 + T[n5];
            n3 = n3 << 7 | n3 >>> 25;
            n4 = n3 ^ n4;
            n2 = this.W[n5];
            n = n2 ^ this.W[n5 + 4];
            n4 = SM3Digest.FF1(n10, n9, n8) + n7 + n4 + n;
            n3 = SM3Digest.GG1(n6, n11, n12) + n13 + n3 + n2;
            n7 = n8;
            n8 = n9 << 9 | n9 >>> 23;
            n9 = n10;
            n10 = n4;
            n13 = n12;
            n12 = n11 << 19 | n11 >>> 13;
            n11 = n6;
            n6 = SM3Digest.P0(n3);
        }
        this.V[0] = this.V[0] ^ n10;
        this.V[1] = this.V[1] ^ n9;
        this.V[2] = this.V[2] ^ n8;
        this.V[3] = this.V[3] ^ n7;
        this.V[4] = this.V[4] ^ n6;
        this.V[5] = this.V[5] ^ n11;
        this.V[6] = this.V[6] ^ n12;
        this.V[7] = this.V[7] ^ n13;
        this.xOff = 0;
    }

    static {
        int n;
        T = new int[64];
        for (n = 0; n < 16; ++n) {
            SM3Digest.T[n] = 2043430169 << n | 2043430169 >>> 32 - n;
        }
        for (n = 16; n < 64; ++n) {
            int n2 = n % 32;
            SM3Digest.T[n] = 2055708042 << n2 | 2055708042 >>> 32 - n2;
        }
    }
}

