/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public final class PKCS12ParametersGenerator
extends PBEParametersGenerator {
    private Digest digest;
    private int u;
    private int v;

    public PKCS12ParametersGenerator(Digest digest) {
        this.digest = digest;
        if (digest instanceof ExtendedDigest) {
            this.u = digest.getDigestSize();
            this.v = ((ExtendedDigest)digest).getByteLength();
            return;
        }
        throw new IllegalArgumentException("Digest " + digest.getAlgorithmName() + " unsupported");
    }

    public final CipherParameters generateDerivedMacParameters(int n) {
        byte[] byArray;
        byte[] byArray2;
        int n2 = n /= 8;
        int n3 = 3;
        Object object = this;
        byte[] byArray3 = new byte[((PKCS12ParametersGenerator)object).v];
        byte[] byArray4 = new byte[n2];
        for (int i = 0; i != byArray3.length; ++i) {
            byArray3[i] = 3;
        }
        if (((PBEParametersGenerator)object).salt != null && ((PBEParametersGenerator)object).salt.length != 0) {
            byArray2 = new byte[((PKCS12ParametersGenerator)object).v * ((((PBEParametersGenerator)object).salt.length + ((PKCS12ParametersGenerator)object).v - 1) / ((PKCS12ParametersGenerator)object).v)];
            for (int i = 0; i != byArray2.length; ++i) {
                byArray2[i] = ((PBEParametersGenerator)object).salt[i % ((PBEParametersGenerator)object).salt.length];
            }
        } else {
            byArray2 = new byte[]{};
        }
        if (((PBEParametersGenerator)object).password != null && ((PBEParametersGenerator)object).password.length != 0) {
            byArray = new byte[((PKCS12ParametersGenerator)object).v * ((((PBEParametersGenerator)object).password.length + ((PKCS12ParametersGenerator)object).v - 1) / ((PKCS12ParametersGenerator)object).v)];
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = ((PBEParametersGenerator)object).password[i % ((PBEParametersGenerator)object).password.length];
            }
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray5 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray5, byArray2.length, byArray.length);
        byArray2 = new byte[((PKCS12ParametersGenerator)object).v];
        n2 = (n2 + ((PKCS12ParametersGenerator)object).u - 1) / ((PKCS12ParametersGenerator)object).u;
        byArray = new byte[((PKCS12ParametersGenerator)object).u];
        for (int i = 1; i <= n2; ++i) {
            int n4;
            ((PKCS12ParametersGenerator)object).digest.update(byArray3, 0, byArray3.length);
            ((PKCS12ParametersGenerator)object).digest.update(byArray5, 0, byArray5.length);
            ((PKCS12ParametersGenerator)object).digest.doFinal(byArray, 0);
            for (n4 = 1; n4 < ((PBEParametersGenerator)object).iterationCount; ++n4) {
                ((PKCS12ParametersGenerator)object).digest.update(byArray, 0, byArray.length);
                ((PKCS12ParametersGenerator)object).digest.doFinal(byArray, 0);
            }
            for (n4 = 0; n4 != byArray2.length; ++n4) {
                byArray2[n4] = byArray[n4 % byArray.length];
            }
            for (n4 = 0; n4 != byArray5.length / ((PKCS12ParametersGenerator)object).v; ++n4) {
                byte[] byArray6 = byArray2;
                int n5 = n4 * ((PKCS12ParametersGenerator)object).v;
                byte[] byArray7 = byArray5;
                int n6 = (byArray6[byArray6.length - 1] & 0xFF) + (byArray7[n5 + byArray6.length - 1] & 0xFF) + 1;
                byArray7[n5 + byArray6.length - 1] = (byte)n6;
                n6 >>>= 8;
                for (int j = byArray6.length - 2; j >= 0; --j) {
                    byArray7[n5 + j] = (byte)(n6 += (byArray6[j] & 0xFF) + (byArray7[n5 + j] & 0xFF));
                    n6 >>>= 8;
                }
            }
            if (i == n2) {
                System.arraycopy(byArray, 0, byArray4, (i - 1) * ((PKCS12ParametersGenerator)object).u, byArray4.length - (i - 1) * ((PKCS12ParametersGenerator)object).u);
                continue;
            }
            System.arraycopy(byArray, 0, byArray4, (i - 1) * ((PKCS12ParametersGenerator)object).u, byArray.length);
        }
        object = byArray4;
        return new KeyParameter((byte[])object, 0, n);
    }
}

