/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric.util;

import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.util.DigestFactory;

public interface PBE {

    public static final class Util {
        private static PBEParametersGenerator makePBEGenerator(int n, int n2) {
            PBEParametersGenerator pBEParametersGenerator;
            block35: {
                block37: {
                    block36: {
                        block34: {
                            if (n != 0 && n != 4) break block34;
                            switch (n2) {
                                case 5: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(new MD2Digest());
                                    break block35;
                                }
                                case 0: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createMD5$2a316d12());
                                    break block35;
                                }
                                case 1: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createSHA1$2a316d12());
                                    break block35;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (n != 1 && n != 5) break block36;
                        switch (n2) {
                            case 5: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new MD2Digest());
                                break block35;
                            }
                            case 0: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createMD5$2a316d12());
                                break block35;
                            }
                            case 1: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA1$2a316d12());
                                break block35;
                            }
                            case 2: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new RIPEMD160Digest());
                                break block35;
                            }
                            case 3: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new TigerDigest());
                                break block35;
                            }
                            case 4: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA256$2a316d12());
                                break block35;
                            }
                            case 6: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new GOST3411Digest());
                                break block35;
                            }
                            case 7: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA224$2a316d12());
                                break block35;
                            }
                            case 8: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA384$2a316d12());
                                break block35;
                            }
                            case 9: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA512$2a316d12());
                                break block35;
                            }
                            case 10: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_224$2a316d12());
                                break block35;
                            }
                            case 11: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_256$2a316d12());
                                break block35;
                            }
                            case 12: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_384$2a316d12());
                                break block35;
                            }
                            case 13: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_512$2a316d12());
                                break block35;
                            }
                            case 14: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(new SM3Digest());
                                break block35;
                            }
                            default: {
                                throw new IllegalStateException("unknown digest scheme for PBE PKCS5S2 encryption.");
                            }
                        }
                    }
                    if (n != 2) break block37;
                    switch (n2) {
                        case 5: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new MD2Digest());
                            break block35;
                        }
                        case 0: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createMD5$2a316d12());
                            break block35;
                        }
                        case 1: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA1$2a316d12());
                            break block35;
                        }
                        case 2: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new RIPEMD160Digest());
                            break block35;
                        }
                        case 3: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new TigerDigest());
                            break block35;
                        }
                        case 4: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA256$2a316d12());
                            break block35;
                        }
                        case 6: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new GOST3411Digest());
                            break block35;
                        }
                        case 7: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA224$2a316d12());
                            break block35;
                        }
                        case 8: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA384$2a316d12());
                            break block35;
                        }
                        case 9: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA512$2a316d12());
                            break block35;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                pBEParametersGenerator = new OpenSSLPBEParametersGenerator();
            }
            return pBEParametersGenerator;
        }

        public static CipherParameters makePBEMacParameters(SecretKey object, int n, int n2, int n3, PBEParameterSpec pBEParameterSpec) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(2, n2);
            byte[] byArray = object.getEncoded();
            pBEParametersGenerator.init(object.getEncoded(), pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            object = pBEParametersGenerator.generateDerivedMacParameters(n3);
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            return object;
        }
    }
}

