/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.io.Streams;

final class LMOtsSignature
implements Encodable {
    private final LMOtsParameters type;
    private final byte[] C;
    private final byte[] y;

    private LMOtsSignature(LMOtsParameters lMOtsParameters, byte[] byArray, byte[] byArray2) {
        this.type = lMOtsParameters;
        this.C = byArray;
        this.y = byArray2;
    }

    public static LMOtsSignature getInstance(Object object) throws IOException {
        while (true) {
            if (object instanceof LMOtsSignature) {
                return (LMOtsSignature)object;
            }
            if (object instanceof DataInputStream) {
                LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(((DataInputStream)object).readInt());
                byte[] byArray = new byte[lMOtsParameters.getN()];
                ((DataInputStream)object).readFully(byArray);
                byte[] byArray2 = new byte[lMOtsParameters.getP() * lMOtsParameters.getN()];
                ((DataInputStream)object).readFully(byArray2);
                return new LMOtsSignature(lMOtsParameters, byArray, byArray2);
            }
            if (object instanceof byte[]) {
                LMOtsSignature lMOtsSignature;
                InputStream inputStream = null;
                try {
                    inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    lMOtsSignature = LMOtsSignature.getInstance(inputStream);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
                return lMOtsSignature;
            }
            if (!(object instanceof InputStream)) break;
            object = Streams.readAll((InputStream)object);
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (LMOtsSignature)object;
        if (this.type != null ? !this.type.equals(((LMOtsSignature)object).type) : ((LMOtsSignature)object).type != null) {
            return false;
        }
        if (!Arrays.equals(this.C, ((LMOtsSignature)object).C)) {
            return false;
        }
        return Arrays.equals(this.y, ((LMOtsSignature)object).y);
    }

    public final int hashCode() {
        int n = this.type != null ? this.type.hashCode() : 0;
        n = n * 31 + Arrays.hashCode(this.C);
        n = n * 31 + Arrays.hashCode(this.y);
        return n;
    }

    public final byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.type.getType()).bytes(this.C).bytes(this.y).build();
    }
}

