/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.DigestUtil;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import org.bouncycastle.pqc.crypto.lms.LM_OTS;
import org.bouncycastle.pqc.crypto.lms.LmsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public final class LMSPrivateKeyParameters
extends LMSKeyParameters {
    private static CacheKey T1 = new CacheKey(1);
    private static CacheKey[] internedKeys;
    private final byte[] I;
    private final LMSigParameters parameters;
    private final LMOtsParameters otsParameters;
    private final int maxQ;
    private final byte[] masterSecret;
    private final Map<CacheKey, byte[]> tCache;
    private final int maxCacheR;
    private final Digest tDigest;
    private int q;
    private LMSPublicKeyParameters publicKey;

    private LMSPrivateKeyParameters(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, int n, byte[] byArray, int n2, byte[] byArray2) {
        super(true);
        this.parameters = lMSigParameters;
        this.otsParameters = lMOtsParameters;
        this.q = n;
        this.I = Arrays.clone(byArray);
        this.maxQ = n2;
        this.masterSecret = Arrays.clone(byArray2);
        this.maxCacheR = 1 << this.parameters.getH() + 1;
        this.tCache = new WeakHashMap<CacheKey, byte[]>();
        this.tDigest = DigestUtil.getDigest$d59b23a(lMSigParameters.getDigestOID());
    }

    public static LMSPrivateKeyParameters getInstance(byte[] object, byte[] byArray) throws IOException {
        object = LMSPrivateKeyParameters.getInstance(object);
        v0.publicKey = LMSPublicKeyParameters.getInstance(byArray);
        return object;
    }

    public static LMSPrivateKeyParameters getInstance(Object object) throws IOException {
        while (true) {
            if (object instanceof LMSPrivateKeyParameters) {
                return (LMSPrivateKeyParameters)object;
            }
            if (object instanceof DataInputStream) {
                DataInputStream dataInputStream = (DataInputStream)object;
                if (dataInputStream.readInt() != 0) {
                    throw new IllegalStateException("expected version 0 lms private key");
                }
                object = LMSigParameters.getParametersForType(dataInputStream.readInt());
                LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(dataInputStream.readInt());
                byte[] byArray = new byte[16];
                dataInputStream.readFully(byArray);
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                if (n3 < 0) {
                    throw new IllegalStateException("secret length less than zero");
                }
                if (n3 > dataInputStream.available()) {
                    throw new IOException("secret length exceeded " + dataInputStream.available());
                }
                byte[] byArray2 = new byte[n3];
                dataInputStream.readFully(byArray2);
                return new LMSPrivateKeyParameters((LMSigParameters)object, lMOtsParameters, n, byArray, n2, byArray2);
            }
            if (object instanceof byte[]) {
                InputStream inputStream = null;
                try {
                    inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    object = LMSPrivateKeyParameters.getInstance(inputStream);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
                return object;
            }
            if (!(object instanceof InputStream)) break;
            object = Streams.readAll((InputStream)object);
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public final LMSPublicKeyParameters getPublicKey() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            if (this.publicKey == null) {
                this.publicKey = new LMSPublicKeyParameters(this.parameters, this.otsParameters, this.findT(T1), this.I);
            }
            return this.publicKey;
        }
    }

    private byte[] findT(int n) {
        if (n < this.maxCacheR) {
            return this.findT(n < internedKeys.length ? internedKeys[n] : new CacheKey(n));
        }
        return this.calcT(n);
    }

    private byte[] findT(CacheKey cacheKey) {
        Map<CacheKey, byte[]> map = this.tCache;
        synchronized (map) {
            byte[] byArray = this.tCache.get(cacheKey);
            if (byArray != null) {
                return byArray;
            }
            byArray = this.calcT(cacheKey.index);
            this.tCache.put(cacheKey, byArray);
            return byArray;
        }
    }

    private byte[] calcT(int n) {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        int n2 = lMSPrivateKeyParameters.parameters.getH();
        if (n >= (n2 = 1 << n2)) {
            lMSPrivateKeyParameters = this;
            LmsUtils.byteArray(Arrays.clone(lMSPrivateKeyParameters.I), this.tDigest);
            LmsUtils.u32str(n, this.tDigest);
            LmsUtils.u16str((short)-32126, this.tDigest);
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = this;
            lMSPrivateKeyParameters = lMSPrivateKeyParameters2;
            LMSPrivateKeyParameters lMSPrivateKeyParameters3 = this;
            lMSPrivateKeyParameters = lMSPrivateKeyParameters3;
            lMSPrivateKeyParameters = this;
            byte[] byArray = LM_OTS.lms_ots_generatePublicKey(lMSPrivateKeyParameters2.otsParameters, Arrays.clone(lMSPrivateKeyParameters3.I), n - n2, Arrays.clone(lMSPrivateKeyParameters.masterSecret));
            LmsUtils.byteArray(byArray, this.tDigest);
            byte[] byArray2 = new byte[this.tDigest.getDigestSize()];
            this.tDigest.doFinal(byArray2, 0);
            return byArray2;
        }
        byte[] byArray = this.findT(2 * n);
        byte[] byArray3 = this.findT(2 * n + 1);
        lMSPrivateKeyParameters = this;
        LmsUtils.byteArray(Arrays.clone(lMSPrivateKeyParameters.I), this.tDigest);
        LmsUtils.u32str(n, this.tDigest);
        LmsUtils.u16str((short)-31869, this.tDigest);
        LmsUtils.byteArray(byArray, this.tDigest);
        LmsUtils.byteArray(byArray3, this.tDigest);
        byte[] byArray4 = new byte[this.tDigest.getDigestSize()];
        this.tDigest.doFinal(byArray4, 0);
        return byArray4;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (LMSPrivateKeyParameters)object;
        if (this.q != ((LMSPrivateKeyParameters)object).q) {
            return false;
        }
        if (this.maxQ != ((LMSPrivateKeyParameters)object).maxQ) {
            return false;
        }
        byte[] byArray = ((LMSPrivateKeyParameters)object).I;
        byte[] byArray2 = this.I;
        if (!java.util.Arrays.equals(this.I, byArray)) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(((LMSPrivateKeyParameters)object).parameters) : ((LMSPrivateKeyParameters)object).parameters != null) {
            return false;
        }
        if (this.otsParameters != null ? !this.otsParameters.equals(((LMSPrivateKeyParameters)object).otsParameters) : ((LMSPrivateKeyParameters)object).otsParameters != null) {
            return false;
        }
        byArray = ((LMSPrivateKeyParameters)object).masterSecret;
        byArray2 = this.masterSecret;
        if (!java.util.Arrays.equals(this.masterSecret, byArray)) {
            return false;
        }
        if (this.publicKey != null && ((LMSPrivateKeyParameters)object).publicKey != null) {
            return this.publicKey.equals(((LMSPrivateKeyParameters)object).publicKey);
        }
        return true;
    }

    public final int hashCode() {
        int n = this.q;
        n = n * 31 + Arrays.hashCode(this.I);
        n = n * 31 + (this.parameters != null ? this.parameters.hashCode() : 0);
        n = n * 31 + (this.otsParameters != null ? this.otsParameters.hashCode() : 0);
        n = n * 31 + this.maxQ;
        n = n * 31 + Arrays.hashCode(this.masterSecret);
        n = n * 31 + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return n;
    }

    public final byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(0).u32str(this.parameters.getType()).u32str(this.otsParameters.getType()).bytes(this.I).u32str(this.q).u32str(this.maxQ).u32str(this.masterSecret.length).bytes(this.masterSecret).build();
    }

    static {
        CacheKey[] cacheKeyArray = new CacheKey[129];
        internedKeys = cacheKeyArray;
        cacheKeyArray[1] = T1;
        for (int i = 2; i < internedKeys.length; ++i) {
            LMSPrivateKeyParameters.internedKeys[i] = new CacheKey(i);
        }
    }

    private static final class CacheKey {
        private final int index;

        CacheKey(int n) {
            this.index = n;
        }

        public final int hashCode() {
            return this.index;
        }

        public final boolean equals(Object object) {
            if (object instanceof CacheKey) {
                return ((CacheKey)object).index == this.index;
            }
            return false;
        }
    }
}

