/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public final class LMSPublicKeyParameters
extends LMSKeyParameters {
    private final LMSigParameters parameterSet;
    private final LMOtsParameters lmOtsType;
    private final byte[] I;
    private final byte[] T1;

    public LMSPublicKeyParameters(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, byte[] byArray, byte[] byArray2) {
        super(false);
        this.parameterSet = lMSigParameters;
        this.lmOtsType = lMOtsParameters;
        this.I = Arrays.clone(byArray2);
        this.T1 = Arrays.clone(byArray);
    }

    public static LMSPublicKeyParameters getInstance(Object object) throws IOException {
        while (true) {
            if (object instanceof LMSPublicKeyParameters) {
                return (LMSPublicKeyParameters)object;
            }
            if (object instanceof DataInputStream) {
                int n = ((DataInputStream)object).readInt();
                LMSigParameters lMSigParameters = LMSigParameters.getParametersForType(n);
                LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(((DataInputStream)object).readInt());
                byte[] byArray = new byte[16];
                ((DataInputStream)object).readFully(byArray);
                byte[] byArray2 = new byte[lMSigParameters.getM()];
                ((DataInputStream)object).readFully(byArray2);
                return new LMSPublicKeyParameters(lMSigParameters, lMOtsParameters, byArray2, byArray);
            }
            if (object instanceof byte[]) {
                LMSPublicKeyParameters lMSPublicKeyParameters;
                InputStream inputStream = null;
                try {
                    inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(inputStream);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
                return lMSPublicKeyParameters;
            }
            if (!(object instanceof InputStream)) break;
            object = Streams.readAll((InputStream)object);
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public final byte[] getEncoded() throws IOException {
        LMSPublicKeyParameters lMSPublicKeyParameters = this;
        return Composer.compose().u32str(lMSPublicKeyParameters.parameterSet.getType()).u32str(lMSPublicKeyParameters.lmOtsType.getType()).bytes(lMSPublicKeyParameters.I).bytes(lMSPublicKeyParameters.T1).build();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (LMSPublicKeyParameters)object;
        if (!this.parameterSet.equals(((LMSPublicKeyParameters)object).parameterSet)) {
            return false;
        }
        if (!this.lmOtsType.equals(((LMSPublicKeyParameters)object).lmOtsType)) {
            return false;
        }
        byte[] byArray = ((LMSPublicKeyParameters)object).I;
        byte[] byArray2 = this.I;
        if (!java.util.Arrays.equals(this.I, byArray)) {
            return false;
        }
        byArray = ((LMSPublicKeyParameters)object).T1;
        byArray2 = this.T1;
        return java.util.Arrays.equals(this.T1, byArray);
    }

    public final int hashCode() {
        int n = this.parameterSet.hashCode();
        n = n * 31 + this.lmOtsType.hashCode();
        n = n * 31 + Arrays.hashCode(this.I);
        n = n * 31 + Arrays.hashCode(this.T1);
        return n;
    }
}

