/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.io.Streams;

final class LMSSignature
implements Encodable {
    private final int q;
    private final LMOtsSignature otsSignature;
    private final LMSigParameters parameter;
    private final byte[][] y;

    private LMSSignature(int n, LMOtsSignature lMOtsSignature, LMSigParameters lMSigParameters, byte[][] byArray) {
        this.q = n;
        this.otsSignature = lMOtsSignature;
        this.parameter = lMSigParameters;
        this.y = byArray;
    }

    public static LMSSignature getInstance(Object object) throws IOException {
        while (true) {
            if (object instanceof LMSSignature) {
                return (LMSSignature)object;
            }
            if (object instanceof DataInputStream) {
                int n = ((DataInputStream)object).readInt();
                LMOtsSignature lMOtsSignature = LMOtsSignature.getInstance(object);
                LMSigParameters lMSigParameters = LMSigParameters.getParametersForType(((DataInputStream)object).readInt());
                byte[][] byArrayArray = new byte[lMSigParameters.getH()][];
                for (int i = 0; i < byArrayArray.length; ++i) {
                    byArrayArray[i] = new byte[lMSigParameters.getM()];
                    ((DataInputStream)object).readFully(byArrayArray[i]);
                }
                return new LMSSignature(n, lMOtsSignature, lMSigParameters, byArrayArray);
            }
            if (object instanceof byte[]) {
                LMSSignature lMSSignature;
                InputStream inputStream = null;
                try {
                    inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    lMSSignature = LMSSignature.getInstance(inputStream);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
                return lMSSignature;
            }
            if (!(object instanceof InputStream)) break;
            object = Streams.readAll((InputStream)object);
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (LMSSignature)object;
        if (this.q != ((LMSSignature)object).q) {
            return false;
        }
        if (this.otsSignature != null ? !this.otsSignature.equals(((LMSSignature)object).otsSignature) : ((LMSSignature)object).otsSignature != null) {
            return false;
        }
        if (this.parameter != null ? !this.parameter.equals(((LMSSignature)object).parameter) : ((LMSSignature)object).parameter != null) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.y, (Object[])((LMSSignature)object).y);
    }

    public final int hashCode() {
        int n = this.q;
        n = n * 31 + (this.otsSignature != null ? this.otsSignature.hashCode() : 0);
        n = n * 31 + (this.parameter != null ? this.parameter.hashCode() : 0);
        n = n * 31 + Arrays.deepHashCode((Object[])this.y);
        return n;
    }

    public final byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.q).bytes(this.otsSignature.getEncoded()).u32str(this.parameter.getType()).bytes(this.y).build();
    }
}

