/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mceliece;

import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2m;

public final class McElieceCCA2PrivateKeyParameters
extends McElieceCCA2KeyParameters {
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private Permutation p;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;

    public McElieceCCA2PrivateKeyParameters(int n, int n2, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, Permutation permutation, String string) {
        this(n, n2, gF2mField, polynomialGF2mSmallM, GoppaCode.createCanonicalCheckMatrix(gF2mField, polynomialGF2mSmallM), permutation, string);
    }

    private McElieceCCA2PrivateKeyParameters(int n, int n2, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, GF2Matrix gF2Matrix, Permutation permutation, String string) {
        super(true, string);
        this.n = n;
        this.k = n2;
        this.field = gF2mField;
        this.goppaPoly = polynomialGF2mSmallM;
        this.h = gF2Matrix;
        this.p = permutation;
        PolynomialRingGF2m polynomialRingGF2m = new PolynomialRingGF2m(gF2mField, polynomialGF2mSmallM);
        this.qInv = polynomialRingGF2m.getSquareRootMatrix();
    }

    public final int getN() {
        return this.n;
    }

    public final int getK() {
        return this.k;
    }

    public final GF2mField getField() {
        return this.field;
    }

    public final PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public final Permutation getP() {
        return this.p;
    }

    public final GF2Matrix getH() {
        return this.h;
    }
}

