/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.util.Arrays;

public final class QTESLAPrivateKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] privateKey;

    public QTESLAPrivateKeyParameters(int n, byte[] byArray) {
        super(true);
        int n2;
        int n3 = byArray.length;
        int n4 = n;
        switch (n4) {
            case 5: {
                n2 = 5224;
                break;
            }
            case 6: {
                n2 = 12392;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + n4);
            }
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = n;
        this.privateKey = Arrays.clone(byArray);
    }

    public final int getSecurityCategory() {
        return this.securityCategory;
    }

    public final byte[] getSecret() {
        return Arrays.clone(this.privateKey);
    }
}

