/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.util.Arrays;

public final class QTESLAPublicKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] publicKey;

    public QTESLAPublicKeyParameters(int n, byte[] byArray) {
        super(false);
        int n2;
        int n3 = byArray.length;
        int n4 = n;
        switch (n4) {
            case 5: {
                n2 = 14880;
                break;
            }
            case 6: {
                n2 = 38432;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + n4);
            }
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = n;
        this.publicKey = Arrays.clone(byArray);
    }

    public final int getSecurityCategory() {
        return this.securityCategory;
    }

    public final byte[] getPublicData() {
        return Arrays.clone(this.publicKey);
    }
}

