/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public final class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(PrivateKeyInfo object) throws IOException {
        Object object2 = ((PrivateKeyInfo)object).getPrivateKeyAlgorithm();
        if (((ASN1ObjectIdentifier)(object2 = ((AlgorithmIdentifier)object2).getAlgorithm())).on(BCObjectIdentifiers.qTESLA)) {
            object2 = ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4());
            return new QTESLAPrivateKeyParameters(Utils.qTeslaLookupSecurityCategory(((PrivateKeyInfo)object).getPrivateKeyAlgorithm()), ((ASN1OctetString)object2).getOctets());
        }
        if (((ASN1Primitive)object2).equals(BCObjectIdentifiers.sphincs256)) {
            return new SPHINCSPrivateKeyParameters(ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4()).getOctets(), Utils.sphincs256LookupTreeAlgName(SPHINCS256KeyParams.getInstance$789c2f4d(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getParameters())));
        }
        if (((ASN1Primitive)object2).equals(BCObjectIdentifiers.newHope)) {
            return new NHPrivateKeyParameters(PrivateKeyFactory.convert(ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4()).getOctets()));
        }
        if (((ASN1Primitive)object2).equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            object2 = ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4()).getOctets();
            ASN1BitString aSN1BitString = ((PrivateKeyInfo)object).getPublicKeyData();
            if (Pack.bigEndianToInt((byte[])object2, 0) == 1) {
                if (aSN1BitString != null) {
                    object = aSN1BitString.getOctets();
                    return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object2, 4, ((Object)object2).length), Arrays.copyOfRange((byte[])object, 4, ((Object)object).length));
                }
                return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object2, 4, ((Object)object2).length));
            }
            if (aSN1BitString != null) {
                object = aSN1BitString.getOctets();
                return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object2, 4, ((Object)object2).length), (byte[])object);
            }
            return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object2, 4, ((Object)object2).length));
        }
        if (((ASN1Primitive)object2).equals(BCObjectIdentifiers.xmss)) {
            object2 = XMSSKeyParams.getInstance$58408def(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ((XMSSKeyParams)object2).getTreeDigest().getAlgorithm();
            object = XMSSPrivateKey.getInstance$2abb9326(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4());
            try {
                object2 = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(((XMSSKeyParams)object2).getHeight(), Utils.getDigest$d59b23a(aSN1ObjectIdentifier))).withIndex(((XMSSPrivateKey)object).getIndex()).withSecretKeySeed(((XMSSPrivateKey)object).getSecretKeySeed()).withSecretKeyPRF(((XMSSPrivateKey)object).getSecretKeyPRF()).withPublicSeed(((XMSSPrivateKey)object).getPublicSeed()).withRoot(((XMSSPrivateKey)object).getRoot());
                if (((XMSSPrivateKey)object).getVersion() != 0) {
                    ((XMSSPrivateKeyParameters.Builder)object2).withMaxIndex(((XMSSPrivateKey)object).getMaxIndex());
                }
                if (((XMSSPrivateKey)object).getBdsState() != null) {
                    object = (BDS)XMSSUtil.deserialize(((XMSSPrivateKey)object).getBdsState(), BDS.class);
                    ((XMSSPrivateKeyParameters.Builder)object2).withBDSState(((BDS)object).withWOTSDigest(aSN1ObjectIdentifier));
                }
                return ((XMSSPrivateKeyParameters.Builder)object2).build();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
            }
        }
        if (((ASN1Primitive)object2).equals(PQCObjectIdentifiers.xmss_mt)) {
            object2 = XMSSMTKeyParams.getInstance$71ba6896(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getParameters());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ((XMSSMTKeyParams)object2).getTreeDigest().getAlgorithm();
            try {
                object = XMSSMTPrivateKey.getInstance$407d0d5f(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4());
                object2 = new XMSSMTPrivateKeyParameters.Builder(new XMSSMTParameters(((XMSSMTKeyParams)object2).getHeight(), ((XMSSMTKeyParams)object2).getLayers(), Utils.getDigest$d59b23a(aSN1ObjectIdentifier))).withIndex(((XMSSMTPrivateKey)object).getIndex()).withSecretKeySeed(((XMSSMTPrivateKey)object).getSecretKeySeed()).withSecretKeyPRF(((XMSSMTPrivateKey)object).getSecretKeyPRF()).withPublicSeed(((XMSSMTPrivateKey)object).getPublicSeed()).withRoot(((XMSSMTPrivateKey)object).getRoot());
                if (((XMSSMTPrivateKey)object).getVersion() != 0) {
                    ((XMSSMTPrivateKeyParameters.Builder)object2).withMaxIndex(((XMSSMTPrivateKey)object).getMaxIndex());
                }
                if (((XMSSMTPrivateKey)object).getBdsState() != null) {
                    object = (BDSStateMap)XMSSUtil.deserialize(((XMSSMTPrivateKey)object).getBdsState(), BDSStateMap.class);
                    ((XMSSMTPrivateKeyParameters.Builder)object2).withBDSState(((BDSStateMap)object).withWOTSDigest(aSN1ObjectIdentifier));
                }
                return ((XMSSMTPrivateKeyParameters.Builder)object2).build();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
            }
        }
        if (((ASN1Primitive)object2).equals(PQCObjectIdentifiers.mcElieceCca2)) {
            object2 = McElieceCCA2PrivateKey.getInstance$7ebe9511(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4());
            return new McElieceCCA2PrivateKeyParameters(((McElieceCCA2PrivateKey)object2).getN(), ((McElieceCCA2PrivateKey)object2).getK(), ((McElieceCCA2PrivateKey)object2).getField(), ((McElieceCCA2PrivateKey)object2).getGoppaPoly(), ((McElieceCCA2PrivateKey)object2).getP(), Utils.getDigestName(((McElieceCCA2PrivateKey)object2).getDigest().getAlgorithm()));
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static short[] convert(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i != sArray.length; ++i) {
            int n = i << 1;
            byte[] byArray2 = byArray;
            int n2 = byArray[n] & 0xFF;
            sArray[i] = (short)(n2 |= (byArray2[++n] & 0xFF) << 8);
        }
        return sArray;
    }
}

