/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import org.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Encodable;

public final class PrivateKeyInfoFactory {
    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter object, ASN1Set aSN1Set) throws IOException {
        if (object instanceof QTESLAPrivateKeyParameters) {
            object = (QTESLAPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(((QTESLAPrivateKeyParameters)object).getSecurityCategory());
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(((QTESLAPrivateKeyParameters)object).getSecret()), aSN1Set);
        }
        if (object instanceof SPHINCSPrivateKeyParameters) {
            object = (SPHINCSPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(((SPHINCSKeyParameters)object).getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(((SPHINCSPrivateKeyParameters)object).getKeyData()));
        }
        if (object instanceof NHPrivateKeyParameters) {
            object = (NHPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = ((NHPrivateKeyParameters)object).getSecData();
            object = sArray;
            byte[] byArray = new byte[sArray.length << 1];
            for (int i = 0; i != ((Object)object).length; ++i) {
                int n = i << 1;
                byte[] byArray2 = byArray;
                Object object2 = object[i];
                byArray2[n] = (byte)object2;
                byArray2[++n] = (byte)(object2 >>> 8);
            }
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (object instanceof LMSPrivateKeyParameters) {
            object = (LMSPrivateKeyParameters)object;
            byte[] byArray = Composer.compose().u32str(1).bytes((Encodable)object).build();
            object = Composer.compose().u32str(1).bytes(((LMSPrivateKeyParameters)object).getPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), aSN1Set, (byte[])object);
        }
        if (object instanceof HSSPrivateKeyParameters) {
            object = (HSSPrivateKeyParameters)object;
            byte[] byArray = Composer.compose().u32str(((HSSPrivateKeyParameters)object).getL()).bytes((Encodable)object).build();
            object = Composer.compose().u32str(((HSSPrivateKeyParameters)object).getL()).bytes(((HSSPrivateKeyParameters)object).getPublicKey().getLMSPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), aSN1Set, (byte[])object);
        }
        if (object instanceof XMSSPrivateKeyParameters) {
            object = (XMSSPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(((XMSSPrivateKeyParameters)object).getParameters().getHeight(), Utils.xmssLookupTreeAlgID(((XMSSKeyParameters)object).getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.xmssCreateKeyStructure((XMSSPrivateKeyParameters)object), aSN1Set);
        }
        if (object instanceof XMSSMTPrivateKeyParameters) {
            object = (XMSSMTPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(((XMSSMTPrivateKeyParameters)object).getParameters().getHeight(), ((XMSSMTPrivateKeyParameters)object).getParameters().getLayers(), Utils.xmssLookupTreeAlgID(((XMSSMTKeyParameters)object).getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.xmssmtCreateKeyStructure((XMSSMTPrivateKeyParameters)object), aSN1Set);
        }
        if (object instanceof McElieceCCA2PrivateKeyParameters) {
            object = (McElieceCCA2PrivateKeyParameters)object;
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = new McElieceCCA2PrivateKey(((McElieceCCA2PrivateKeyParameters)object).getN(), ((McElieceCCA2PrivateKeyParameters)object).getK(), ((McElieceCCA2PrivateKeyParameters)object).getField(), ((McElieceCCA2PrivateKeyParameters)object).getGoppaPoly(), ((McElieceCCA2PrivateKeyParameters)object).getP(), Utils.getAlgorithmIdentifier(((McElieceCCA2KeyParameters)object).getDigest()));
            object = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            return new PrivateKeyInfo((AlgorithmIdentifier)object, mcElieceCCA2PrivateKey);
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey xmssCreateKeyStructure(XMSSPrivateKeyParameters xMSSPrivateKeyParameters) throws IOException {
        BDS bDS;
        byte[] byArray = xMSSPrivateKeyParameters.getEncoded();
        int n = xMSSPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n2 = xMSSPrivateKeyParameters.getParameters().getHeight();
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = (int)XMSSUtil.bytesToXBigEndian(byArray, 0, 4);
        if (!XMSSUtil.isIndexValid(n2, n6)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, 4, n3);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n3 += 4, n4);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n3 += n4, n5);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n3 += n5, n);
        byArray = XMSSUtil.extractBytesAtOffset(byArray, n3 += n, byArray.length - n3);
        try {
            bDS = (BDS)XMSSUtil.deserialize(byArray, BDS.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDS: " + classNotFoundException.getMessage());
        }
        if (bDS.getMaxIndex() != (1 << n2) - 1) {
            return new XMSSPrivateKey(n6, byArray2, byArray3, byArray4, byArray5, byArray, bDS.getMaxIndex());
        }
        return new XMSSPrivateKey(n6, byArray2, byArray3, byArray4, byArray5, byArray);
    }

    private static XMSSMTPrivateKey xmssmtCreateKeyStructure(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) throws IOException {
        BDSStateMap bDSStateMap;
        byte[] byArray = xMSSMTPrivateKeyParameters.getEncoded();
        int n = xMSSMTPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n2 = xMSSMTPrivateKeyParameters.getParameters().getHeight();
        int n3 = (n2 + 7) / 8;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = (int)XMSSUtil.bytesToXBigEndian(byArray, 0, n3);
        if (!XMSSUtil.isIndexValid(n2, n7)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n3 += 0, n4);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n3 += n4, n5);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n3 += n5, n6);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n3 += n6, n);
        byArray = XMSSUtil.extractBytesAtOffset(byArray, n3 += n, byArray.length - n3);
        try {
            bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(byArray, BDSStateMap.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDSStateMap: " + classNotFoundException.getMessage());
        }
        if (bDSStateMap.getMaxIndex() != (1L << n2) - 1L) {
            return new XMSSMTPrivateKey(n7, byArray2, byArray3, byArray4, byArray5, byArray, bDSStateMap.getMaxIndex());
        }
        return new XMSSMTPrivateKey(n7, byArray2, byArray3, byArray4, byArray5, byArray);
    }
}

