/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public class BDSStateMap
implements Serializable {
    private final Map<Integer, BDS> bdsState = new TreeMap<Integer, BDS>();
    private transient long maxIndex;

    BDSStateMap(long l) {
        this.maxIndex = l;
    }

    BDSStateMap(BDSStateMap bDSStateMap, long l) {
        for (Integer n : bDSStateMap.bdsState.keySet()) {
            this.bdsState.put(n, new BDS(bDSStateMap.bdsState.get(n)));
        }
        this.maxIndex = l;
    }

    BDSStateMap(XMSSMTParameters xMSSMTParameters, long l, byte[] byArray, byte[] byArray2) {
        this.maxIndex = (1L << xMSSMTParameters.getHeight()) - 1L;
        for (long i = 0L; i < l; ++i) {
            int n;
            byte[] byArray3 = byArray2;
            byte[] byArray4 = byArray;
            long l2 = i;
            XMSSMTParameters xMSSMTParameters2 = xMSSMTParameters;
            BDSStateMap bDSStateMap = this;
            XMSSParameters xMSSParameters = xMSSMTParameters2.getXMSSParameters();
            int n2 = n = xMSSParameters.getHeight();
            long l3 = l2;
            long l4 = l3 >> n2;
            int n3 = XMSSUtil.getLeafIndex(l2, n);
            OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l4)).withOTSAddress(n3).build();
            if (n3 < (1 << n) - 1) {
                boolean bl = false;
                BDSStateMap bDSStateMap2 = bDSStateMap;
                int n4 = 0;
                if (bDSStateMap2.bdsState.get(0) == null || n3 == 0) {
                    BDS bDS = new BDS(xMSSParameters, byArray4, byArray3, oTSHashAddress);
                    bl = false;
                    bDSStateMap2 = bDSStateMap;
                    n4 = 0;
                    bDSStateMap2.bdsState.put(0, bDS);
                }
                bDSStateMap.update(0, byArray4, byArray3, oTSHashAddress);
            }
            for (int j = 1; j < xMSSMTParameters2.getLayers(); ++j) {
                int n5;
                block8: {
                    block7: {
                        n3 = XMSSUtil.getLeafIndex(l4, n);
                        int n6 = n;
                        l3 = l4;
                        l4 = l3 >> n6;
                        oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(j)).withTreeAddress(l4)).withOTSAddress(n3).build();
                        if (bDSStateMap.bdsState.get(j) == null) break block7;
                        n5 = j;
                        int n7 = n;
                        long l5 = l2;
                        if (!(l5 != 0L && l5 % (long)Math.pow(1 << n7, n5 + 1) == 0L)) break block8;
                    }
                    bDSStateMap.bdsState.put(j, new BDS(xMSSParameters, byArray4, byArray3, oTSHashAddress));
                }
                if (n3 >= (1 << n) - 1) continue;
                n5 = j;
                int n8 = n;
                long l6 = l2;
                if (!(l6 != 0L && (l6 + 1L) % (long)Math.pow(1 << n8, n5) == 0L)) continue;
                bDSStateMap.update(j, byArray4, byArray3, oTSHashAddress);
            }
        }
    }

    public final long getMaxIndex() {
        return this.maxIndex;
    }

    private BDS update(int n, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        int n2 = n;
        int n3 = n2;
        n3 = n;
        return this.bdsState.put(n2, this.bdsState.get(n3).getNextState(byArray, byArray2, oTSHashAddress));
    }

    public final BDSStateMap withWOTSDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        BDSStateMap bDSStateMap = new BDSStateMap(this.maxIndex);
        for (Integer n : this.bdsState.keySet()) {
            bDSStateMap.bdsState.put(n, this.bdsState.get(n).withWOTSDigest(aSN1ObjectIdentifier));
        }
        return bDSStateMap;
    }
}

