/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle.util.Pack;

final class HashTreeAddress
extends XMSSAddress {
    private final int padding;
    private final int treeHeight;
    private final int treeIndex;

    private HashTreeAddress(Builder builder) {
        super(builder);
        this.padding = 0;
        this.treeHeight = builder.treeHeight;
        this.treeIndex = builder.treeIndex;
    }

    protected final byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        Pack.intToBigEndian(this.padding, byArray, 16);
        Pack.intToBigEndian(this.treeHeight, byArray, 20);
        Pack.intToBigEndian(this.treeIndex, byArray, 24);
        return byArray;
    }

    protected final int getTreeHeight() {
        return this.treeHeight;
    }

    protected final int getTreeIndex() {
        return this.treeIndex;
    }

    /* synthetic */ HashTreeAddress(Builder builder, byte by) {
        this(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Builder
    extends XMSSAddress.Builder<Builder> {
        private int treeHeight = 0;
        private int treeIndex = 0;

        protected Builder() {
            super(2);
        }

        protected final Builder withTreeHeight(int n) {
            this.treeHeight = n;
            return this;
        }

        protected final Builder withTreeIndex(int n) {
            this.treeIndex = n;
            return this;
        }

        @Override
        protected final XMSSAddress build() {
            return new HashTreeAddress(this, 0);
        }
    }
}

