/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.pqc.crypto.xmss.DigestUtil;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class KeyedHashFunctions {
    private final Digest digest;
    private final int digestSize;

    protected KeyedHashFunctions(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        if (aSN1ObjectIdentifier == null) {
            throw new NullPointerException("digest == null");
        }
        this.digest = DigestUtil.getDigest$d59b23a(aSN1ObjectIdentifier);
        this.digestSize = n;
    }

    private byte[] coreDigest(int n, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = XMSSUtil.toBytesBigEndian(n, this.digestSize);
        this.digest.update(byArray3, 0, byArray3.length);
        this.digest.update(byArray, 0, byArray.length);
        this.digest.update(byArray2, 0, byArray2.length);
        byArray3 = new byte[this.digestSize];
        if (this.digest instanceof Xof) {
            ((Xof)this.digest).doFinal(byArray3, 0, this.digestSize);
        } else {
            this.digest.doFinal(byArray3, 0);
        }
        return byArray3;
    }

    protected final byte[] F(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (byArray2.length != this.digestSize) {
            throw new IllegalArgumentException("wrong in length");
        }
        return this.coreDigest(0, byArray, byArray2);
    }

    protected final byte[] H(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (byArray2.length != 2 * this.digestSize) {
            throw new IllegalArgumentException("wrong in length");
        }
        return this.coreDigest(1, byArray, byArray2);
    }

    protected final byte[] PRF(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (byArray2.length != 32) {
            throw new IllegalArgumentException("wrong address length");
        }
        return this.coreDigest(3, byArray, byArray2);
    }
}

