/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle.util.Pack;

final class LTreeAddress
extends XMSSAddress {
    private final int lTreeAddress;
    private final int treeHeight;
    private final int treeIndex;

    private LTreeAddress(Builder builder) {
        super(builder);
        this.lTreeAddress = builder.lTreeAddress;
        this.treeHeight = builder.treeHeight;
        this.treeIndex = builder.treeIndex;
    }

    protected final byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        Pack.intToBigEndian(this.lTreeAddress, byArray, 16);
        Pack.intToBigEndian(this.treeHeight, byArray, 20);
        Pack.intToBigEndian(this.treeIndex, byArray, 24);
        return byArray;
    }

    protected final int getLTreeAddress() {
        return this.lTreeAddress;
    }

    protected final int getTreeHeight() {
        return this.treeHeight;
    }

    protected final int getTreeIndex() {
        return this.treeIndex;
    }

    /* synthetic */ LTreeAddress(Builder builder, byte by) {
        this(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Builder
    extends XMSSAddress.Builder<Builder> {
        private int lTreeAddress = 0;
        private int treeHeight = 0;
        private int treeIndex = 0;

        protected Builder() {
            super(1);
        }

        protected final Builder withLTreeAddress(int n) {
            this.lTreeAddress = n;
            return this;
        }

        protected final Builder withTreeHeight(int n) {
            this.treeHeight = n;
            return this;
        }

        protected final Builder withTreeIndex(int n) {
            this.treeIndex = n;
            return this;
        }

        @Override
        protected final XMSSAddress build() {
            return new LTreeAddress(this, 0);
        }
    }
}

